<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<!-- PAGE HEADER -->
<section class="relative h-[40vh] min-h-[350px] flex items-center overflow-hidden">
    <!-- Background Image (Medical Equipment) -->
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1579684385127-1ef15d508118?auto=format&fit=crop&q=80&w=2000" alt="Advanced Medical Equipment" class="w-full h-full object-cover object-center">
    </div>

    <!-- Curved Overlay -->
    <div class="absolute top-0 left-0 h-full w-[120%] md:w-[70%] bg-gradient-to-r from-[#981B46]/95 via-[#981B46]/80 to-transparent" 
         style="clip-path: ellipse(90% 100% at 0% 50%);">
    </div>

    <!-- Content -->
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <!-- Breadcrumb -->
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2 reveal">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <span class="text-white">About Us</span>
        </div>

        <!-- Title -->
        <h1 class="text-5xl md:text-6xl font-bold text-white tracking-wide reveal reveal-delay-100">
            About Us
        </h1>
    </div>
</section>

<!-- ABOUT SECTION -->
<section class="py-20 relative overflow-hidden">
    <!-- Floating Elements -->
    <div class="floating-shape shape-circle bottom-10 left-1/4"></div>

    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        <div class="flex flex-col lg:flex-row items-center gap-16">
            <!-- Image Collage Left -->
            <div class="w-full lg:w-1/2 relative reveal">
                <div class="grid grid-cols-2 gap-4">
                    <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=600" class="rounded-lg shadow-lg w-full h-64 object-cover mt-12">
                     <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=600" class="rounded-lg shadow-lg w-full h-64 object-cover">
                </div>
                <!-- Central Circle Icon -->
                <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-white p-2 rounded-full shadow-xl">
                    <div class="w-16 h-16 bg-primary rounded-full flex items-center justify-center text-white text-2xl animate-pulse">
                        <i class="fas fa-plus"></i>
                    </div>
                </div>
            </div>

            <!-- Text Right -->
            <div class="w-full lg:w-1/2 reveal reveal-delay-200">
                <h5 class="text-primary font-bold uppercase tracking-widest mb-2">Who We Are</h5>
                <h2 class="text-4xl font-bold text-dark mb-6 leading-tight">Delivering Advanced Medical <br> Technology With Trusted Support</h2>
                <p class="text-grayish mb-6 text-lg">
                    Specialized Medical Solutions (SMS) is a leading provider of medical equipment and healthcare technology in Qatar. We are dedicated to improving patient care through innovative solutions and reliable service.
                </p>
                <p class="text-grayish mb-6 text-lg">
                    Our team of experts works closely with healthcare professionals to understand their needs and provide tailored solutions that enhance efficiency and outcomes. From state-of-the-art imaging systems to comprehensive clinical management software, we are your partners in health.
                </p>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 rounded bg-primary/10 flex items-center justify-center text-primary text-xl flex-shrink-0">
                            <i class="fas fa-check"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-dark text-lg">Certified Experts</h4>
                            <p class="text-sm text-gray-500">Professional and experienced team.</p>
                        </div>
                    </div>
                    <div class="flex items-start gap-4">
                         <div class="w-12 h-12 rounded bg-primary/10 flex items-center justify-center text-primary text-xl flex-shrink-0">
                            <i class="fas fa-star"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-dark text-lg">Quality Service</h4>
                            <p class="text-sm text-gray-500">Committed to excellence in every project.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- VISION & MISSION -->
<section class="py-24 relative overflow-hidden">
    <!-- Background Patterns -->
    <div class="absolute top-0 right-0 w-1/3 h-full bg-primary/5 skewed-bg transform skew-x-12 translate-x-1/2"></div>
    <div class="absolute bottom-0 left-0 w-64 h-64 bg-gray-200/50 rounded-full blur-3xl"></div>

    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-16 items-stretch">
             <!-- Vision Card -->
             <div class="group relative bg-white p-10 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 reveal">
                 <!-- Hover Background Image -->
                 <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover">
                    <div class="absolute inset-0 bg-primary/90 mix-blend-multiply"></div>
                 </div>
                 
                 <div class="relative z-10">
                     <div class="w-20 h-20 bg-primary/10 rounded-2xl flex items-center justify-center text-primary text-4xl mb-8 group-hover:bg-white group-hover:text-primary group-hover:scale-110 transition-all duration-300 shadow-sm">
                         <i class="fas fa-eye"></i>
                     </div>
                     <h3 class="text-3xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Our Vision</h3>
                     <p class="text-gray-500 text-lg leading-relaxed mb-6 group-hover:text-white transition-colors">To be the most trusted partner in healthcare technology, transforming the medical landscape in the region through innovation, reliability, and excellence.</p>
                     
                     <div class="w-12 h-1 bg-gray-200 group-hover:bg-white transition-colors"></div>
                 </div>
             </div>

             <!-- Mission Card -->
             <div class="group relative bg-white p-10 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 reveal reveal-delay-200">
                 <!-- Hover Background Image -->
                 <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    <img src="https://images.unsplash.com/photo-1522202176988-66273c2fd55f?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover">
                    <div class="absolute inset-0 bg-dark/90 mix-blend-multiply"></div>
                 </div>

                 <div class="relative z-10">
                     <div class="w-20 h-20 bg-dark/10 rounded-2xl flex items-center justify-center text-dark text-4xl mb-8 group-hover:bg-white group-hover:text-dark group-hover:scale-110 transition-all duration-300 shadow-sm">
                         <i class="fas fa-bullseye"></i>
                     </div>
                     <h3 class="text-3xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Our Mission</h3>
                     <p class="text-gray-500 text-lg leading-relaxed mb-6 group-hover:text-white transition-colors">To provide cutting-edge medical solutions and superior support services that empower healthcare providers to deliver the best patient care.</p>
                     
                     <div class="w-12 h-1 bg-gray-200 group-hover:bg-white transition-colors"></div>
                 </div>
             </div>
        </div>
    </div>
</section>

    <!-- CEO MESSAGE SECTION -->
    <section class="py-20 relative overflow-hidden">
        <!-- Decoration -->
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden z-0 pointer-events-none">
             <div class="absolute -top-24 -left-24 text-[20rem] text-gray-50 opacity-50 z-0 font-serif leading-none select-none">“</div>
             <div class="absolute bottom-0 right-0 w-96 h-96 bg-primary/5 rounded-full blur-3xl z-0"></div>
        </div>
        
        <div class="container mx-auto max-w-7xl px-6 relative z-10">
            <div class="flex flex-col md:flex-row items-center gap-16">
                <!-- Image Side -->
                <div class="w-full md:w-5/12 reveal group">
                     <div class="relative rounded-2xl overflow-hidden shadow-2xl border-[8px] border-white transform transition-transform duration-700 hover:scale-[1.02]">
                          <img src="https://images.unsplash.com/photo-1556157382-97eda2d62296?auto=format&fit=crop&q=80&w=800" alt="CEO" class="w-full h-[500px] object-cover filter grayscale group-hover:grayscale-0 transition-all duration-700">
                          <!-- Decorative box -->
                          <div class="absolute -bottom-10 -right-10 w-32 h-32 bg-primary rounded-full z-10 opacity-80 mix-blend-multiply"></div>
                     </div>
                </div>
                
                <!-- Content Side -->
                <div class="w-full md:w-7/12 reveal reveal-delay-200">
                    <h5 class="text-primary font-bold uppercase tracking-widest mb-4 flex items-center gap-2">
                        <span class="w-8 h-[2px] bg-primary"></span> CEO Message
                    </h5>
                    <h2 class="text-3xl md:text-5xl font-bold text-dark mb-8 leading-tight">Leading with <br><span class="text-primary italic font-light">Innovation & Integrity</span></h2>
                    
                    <div class="relative pl-8 mb-10">
                        <i class="fas fa-quote-left text-4xl text-gray-200 absolute -top-4 -left-2"></i>
                        <p class="text-gray-600 text-lg leading-relaxed italic relative z-10 font-serif text-justify">
                            "At Specialized Medical Solutions, we believe that healthcare is not just a service, but a commitment to humanity. Our journey is defined by our passion for bringing the world's most advanced medical technologies to Qatar, ensuring that our community has access to the best care possible. We don't just supply equipment; we build bridges to a healthier future."
                        </p>
                    </div>
                    
                    <div class="flex items-center gap-6 border-t border-gray-100 pt-8">
                        <div>
                            <h4 class="text-2xl font-bold text-dark">Mr. Ahmed Al-Naimi</h4>
                            <p class="text-primary text-sm font-bold uppercase tracking-wide mt-1">Chief Executive Officer</p>
                        </div>
                        <div class="ml-auto">
                            <!-- Signature approximation -->
                            <div class="text-4xl text-gray-400 -rotate-6 select-none" style="font-family: 'Brush Script MT', cursive;">Ahmed.A</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- MANAGEMENT TEAM TREE -->
    <section class="py-20 relative">
        <div class="container mx-auto max-w-7xl px-6 relative z-10 text-center">
            <h5 class="text-primary font-bold uppercase tracking-widest text-sm mb-2 reveal">Leadership</h5>
            <h2 class="text-4xl font-bold text-dark mb-12 reveal reveal-delay-100">Our Management <span class="italic text-primary font-light">Team</span></h2>

            <div class="tree reveal reveal-delay-200 pb-10 flex justify-center">
                <ul>
                    <!-- GM Node -->
                    <li>
                        <div class="tree-node">
                            <div class="profile-card">
                                <!-- Tooltip -->
                                <div class="profile-tooltip">
                                    <h5 class="text-white font-bold mb-1">John Smith</h5>
                                    <p>Experienced leader with over 15 years in medical technology management. MBA from Harvard Business School.</p>
                                </div>
                                <div class="profile-card-header">
                                    <img src="https://images.unsplash.com/photo-1560250097-0b93528c311a?auto=format&fit=crop&q=80&w=400" alt="John Smith">
                                </div>
                                <div class="profile-card-body">
                                    <div class="profile-name-row">
                                        <div class="profile-name">John Smith</div>
                                        <a href="#" class="profile-linkedin"><i class="fab fa-linkedin"></i></a>
                                    </div>
                                    <div class="profile-role">General Manager</div>
                                </div>
                            </div>
                        </div>

                        <!-- Level 2 -->
                        <ul>
                            <!-- HR -->
                            <li>
                                <div class="tree-node">
                                    <div class="profile-card">
                                        <div class="profile-tooltip">
                                             <h5 class="text-white font-bold mb-1">Sarah Johnson</h5>
                                             <p>Specialist in talent acquisition and organizational development.</p>
                                        </div>
                                        <div class="profile-card-header">
                                            <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?auto=format&fit=crop&q=80&w=400" alt="Sarah Johnson">
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="profile-name-row">
                                                <div class="profile-name">Sarah Johnson</div>
                                                <a href="#" class="profile-linkedin"><i class="fab fa-linkedin"></i></a>
                                            </div>
                                            <div class="profile-role">HR Manager</div>
                                        </div>
                                    </div>
                                </div>
                            </li>

                            <!-- Sales -->
                            <li>
                                <div class="tree-node">
                                    <div class="profile-card">
                                        <div class="profile-tooltip">
                                             <h5 class="text-white font-bold mb-1">Michael Brown</h5>
                                             <p>Driving growth through strategic partnerships and sales excellence.</p>
                                        </div>
                                        <div class="profile-card-header">
                                            <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?auto=format&fit=crop&q=80&w=400" alt="Michael Brown">
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="profile-name-row">
                                                <div class="profile-name">Michael Brown</div>
                                                <a href="#" class="profile-linkedin"><i class="fab fa-linkedin"></i></a>
                                            </div>
                                            <div class="profile-role">Sales Manager</div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Level 3 (Sub-Sales) -->
                                <ul>
                                    <li>
                                         <div class="tree-node">
                                            <div class="profile-card">
                                                <div class="profile-card-header" style="height: 150px;">
                                                    <img src="https://images.unsplash.com/photo-1519085360753-af0119f7cbe7?auto=format&fit=crop&q=80&w=400" alt="Team A">
                                                </div>
                                                <div class="profile-card-body">
                                                    <div class="profile-name-row">
                                                        <div class="profile-name text-sm">Sales Team A</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                     <li>
                                         <div class="tree-node">
                                            <div class="profile-card">
                                                <div class="profile-card-header" style="height: 150px;">
                                                    <img src="https://images.unsplash.com/photo-1522071820081-009f0129c71c?auto=format&fit=crop&q=80&w=400" alt="Team B">
                                                </div>
                                                <div class="profile-card-body">
                                                    <div class="profile-name-row">
                                                        <div class="profile-name text-sm">Sales Team B</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </li>

                            <!-- Operations -->
                            <li>
                                <div class="tree-node">
                                    <div class="profile-card">
                                        <div class="profile-tooltip">
                                            <h5 class="text-white font-bold mb-1">David Wilson</h5>
                                            <p>Optimizing operational efficiency and supply chain management.</p>
                                        </div>
                                        <div class="profile-card-header">
                                            <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?auto=format&fit=crop&q=80&w=400" alt="David Wilson">
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="profile-name-row">
                                                <div class="profile-name">David Wilson</div>
                                                <a href="#" class="profile-linkedin"><i class="fab fa-linkedin"></i></a>
                                            </div>
                                            <div class="profile-role">Operations Mgr</div>
                                        </div>
                                    </div>
                                </div>
                            </li>

                            <!-- Technical -->
                             <li>
                                <div class="tree-node">
                                    <div class="profile-card">
                                        <div class="profile-tooltip">
                                            <h5 class="text-white font-bold mb-1">Emily Davis</h5>
                                            <p>Leading technical support and biomedical engineering teams.</p>
                                        </div>
                                        <div class="profile-card-header">
                                            <img src="https://images.unsplash.com/photo-1580489944761-15a19d654956?auto=format&fit=crop&q=80&w=400" alt="Emily Davis">
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="profile-name-row">
                                                <div class="profile-name">Emily Davis</div>
                                                <a href="#" class="profile-linkedin"><i class="fab fa-linkedin"></i></a>
                                            </div>
                                            <div class="profile-role">Technical Mgr</div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </section>

<?php include 'footer.php'; ?>
