<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="relative h-[40vh] min-h-[350px] flex items-center overflow-hidden">
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1521791136064-7986c2920216?auto=format&fit=crop&q=80&w=2000" alt="Background" class="w-full h-full object-cover object-center">
    </div>
    <div class="absolute top-0 left-0 h-full w-full bg-gradient-to-r from-[#981B46]/95 via-[#981B46]/80 to-transparent"></div>
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2 reveal">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <span class="text-white">Careers</span>
        </div>
        <h1 class="text-5xl md:text-6xl font-bold text-white tracking-wide reveal reveal-delay-100">
            Work With Us
        </h1>
    </div>
</section>

<!-- CURRENT OPENINGS -->
<section class="py-20 relative">
    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        
        <div class="text-center mb-16 reveal">
            <h5 class="text-primary font-bold uppercase tracking-widest text-sm mb-2">Join Our Team</h5>
            <h2 class="text-4xl font-bold text-dark">Current <span class="text-primary italic font-light">Openings</span></h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            
            <!-- Job Card 1 -->
            <div class="group bg-white/10 backdrop-blur-md border border-white/20 p-8 rounded-2xl hover:bg-white/20 transition-all duration-300 shadow-sm hover:shadow-xl reveal reveal-delay-100">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <span class="inline-block bg-primary/10 text-primary text-xs font-bold px-3 py-1 rounded-full mb-2">Full Time</span>
                        <h3 class="text-2xl font-bold text-dark group-hover:text-primary transition-colors">Biomedical Engineer</h3>
                    </div>
                    <div class="w-10 h-10 bg-white rounded-full flex items-center justify-center text-gray-400 shadow-sm">
                        <i class="fas fa-microchip"></i>
                    </div>
                </div>
                
                <p class="text-gray-600 mb-6 text-sm leading-relaxed">
                    We are looking for a skilled Biomedical Engineer to install, maintain, and repair medical equipment. You will ensure that all medical systems are functioning at peak performance.
                </p>

                <div class="mb-6">
                    <h4 class="font-bold text-dark text-sm mb-2">Requirements:</h4>
                    <ul class="text-sm text-gray-500 space-y-2">
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> Bachelor's degree in Biomedical Engineering</li>
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> 2+ years of experience in medical equipment maintenance</li>
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> Strong troubleshooting skills</li>
                    </ul>
                </div>

                <a href="mailto:info@smsqatar.org?subject=Application for Biomedical Engineer" 
                   class="inline-block w-full text-center bg-primary text-white font-bold uppercase tracking-wide py-3 rounded-lg hover:bg-dark transition-colors duration-300">
                    Apply Now
                </a>
            </div>

            <!-- Job Card 2 -->
             <div class="group bg-white/10 backdrop-blur-md border border-white/20 p-8 rounded-2xl hover:bg-white/20 transition-all duration-300 shadow-sm hover:shadow-xl reveal reveal-delay-200">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <span class="inline-block bg-primary/10 text-primary text-xs font-bold px-3 py-1 rounded-full mb-2">Full Time</span>
                        <h3 class="text-2xl font-bold text-dark group-hover:text-primary transition-colors">Medical Sales Representative</h3>
                    </div>
                    <div class="w-10 h-10 bg-white rounded-full flex items-center justify-center text-gray-400 shadow-sm">
                        <i class="fas fa-briefcase"></i>
                    </div>
                </div>
                
                <p class="text-gray-600 mb-6 text-sm leading-relaxed">
                    Join our dynamic sales team to promote our advanced medical solutions. You will be responsible for building relationships with healthcare providers and achieving sales targets.
                </p>

                <div class="mb-6">
                    <h4 class="font-bold text-dark text-sm mb-2">Requirements:</h4>
                    <ul class="text-sm text-gray-500 space-y-2">
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> Proven track record in medical devices sales</li>
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> Excellent communication and negotiation skills</li>
                        <li class="flex items-center gap-2"><i class="fas fa-check text-primary text-xs"></i> Valid Qatar driving license</li>
                    </ul>
                </div>

                <a href="mailto:info@smsqatar.org?subject=Application for Medical Sales Representative" 
                   class="inline-block w-full text-center bg-primary text-white font-bold uppercase tracking-wide py-3 rounded-lg hover:bg-dark transition-colors duration-300">
                    Apply Now
                </a>
            </div>

        </div>
    </div>
</section>

<?php include 'footer.php'; ?>
