<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="relative bg-gray-100 py-20 overflow-hidden">
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1516387938699-a93567ec168e?auto=format&fit=crop&q=80&w=2000" alt="Contact Background" class="w-full h-full object-cover opacity-20">
    </div>
    <div class="container mx-auto max-w-7xl px-6 relative z-10 text-center">
        <h1 class="text-4xl md:text-5xl font-bold text-dark mb-4">Contact Us</h1>
        <div class="flex justify-center items-center gap-2 text-sm font-medium text-gray-500">
            <a href="index.php" class="hover:text-primary transition-colors">Home</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <span class="text-primary">Contact</span>
        </div>
    </div>
</section>

<!-- CONTACT INFO & FORM -->
<section class="py-20 bg-white">
    <div class="container mx-auto max-w-7xl px-6">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-10">
            
            <!-- Contact Info Cards -->
            <div class="lg:col-span-1 space-y-6">
                <!-- Card 1 -->
                <div class="bg-gray-50 p-8 rounded-xl shadow-sm border border-gray-100 flex items-start gap-4 hover:-translate-y-1 transition-transform">
                    <div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl shrink-0">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-dark text-lg mb-2">Location</h4>
                        <p class="text-gray-500 mb-1">Al Jazira Arabiya St.</p>
                        <p class="text-gray-500">Doha, Qatar</p>
                    </div>
                </div>
                <!-- Card 2 -->
                <div class="bg-gray-50 p-8 rounded-xl shadow-sm border border-gray-100 flex items-start gap-4 hover:-translate-y-1 transition-transform">
                    <div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl shrink-0">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-dark text-lg mb-2">Email Us</h4>
                        <p class="text-gray-500 mb-1">info@smsqatar.org</p>
                        <p class="text-gray-500">support@smsqatar.org</p>
                    </div>
                </div>
                <!-- Card 3 -->
                <div class="bg-gray-50 p-8 rounded-xl shadow-sm border border-gray-100 flex items-start gap-4 hover:-translate-y-1 transition-transform">
                    <div class="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl shrink-0">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-dark text-lg mb-2">Call Us</h4>
                        <p class="text-gray-500 mb-1">+974-44620491</p>
                        <p class="text-gray-500">Mon - Fri, 08:00 AM - 06:00 PM</p>
                    </div>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="lg:col-span-2 bg-white rounded-xl shadow-lg border border-gray-100 p-8 md:p-10">
                <h3 class="text-2xl font-bold text-dark mb-6">Send us a Message</h3>
                <form action="#" method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label class="block text-sm font-bold text-dark mb-2">First Name</label>
                            <input type="text" class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors" placeholder="John">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-dark mb-2">Last Name</label>
                            <input type="text" class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors" placeholder="Doe">
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label class="block text-sm font-bold text-dark mb-2">Email Address</label>
                            <input type="email" class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors" placeholder="john@example.com">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-dark mb-2">Phone Number</label>
                            <input type="text" class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors" placeholder="+974...">
                        </div>
                    </div>
                    <div class="mb-6">
                        <label class="block text-sm font-bold text-dark mb-2">Subject</label>
                         <input type="text" class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors" placeholder="How can we help?">
                    </div>
                    <div class="mb-8">
                        <label class="block text-sm font-bold text-dark mb-2">Message</label>
                        <textarea class="w-full bg-gray-50 border border-gray-200 rounded px-4 py-3 focus:outline-none focus:border-primary transition-colors h-32" placeholder="Write your message here..."></textarea>
                    </div>
                    <button type="submit" class="bg-primary text-white px-8 py-3 rounded font-bold uppercase hover:bg-dark transition-colors w-full md:w-auto">Send Message</button>
                </form>
            </div>

        </div>
    </div>
</section>

<!-- MAP SECTION -->
<section class="h-96 w-full relative">
    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d154446.436329064!2d51.41908709564883!3d25.285447299999998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e45c534ffdce87f%3A0x44d9319f78cfd4b1!2sDoha%2C%20Qatar!5e0!3m2!1sen!2sus!4v1652876543123!5m2!1sen!2sus" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
</section>

<?php include 'footer.php'; ?>
