<footer class="bg-black text-white relative py-12 overflow-hidden border-t-4 border-primary">
    <div class="container mx-auto max-w-7xl px-6 relative z-10 flex flex-col md:flex-row justify-between items-center gap-6">
        <!-- Logo and Arabic Text -->
        <div class="flex flex-col items-center md:items-start text-center md:text-left">
             <img src="Assets/Images/logoMain.svg" alt="Specialized Medical Solutions" class="h-16 mb-4 brightness-0 invert">
             <div class="text-right">
                  <h4 class="font-bold text-lg leading-tight uppercase tracking-wider">Specialized Medical Solutions <span class="text-xs align-top">W.L.L</span></h4>
                  <h4 class="font-bold text-lg leading-tight font-serif" dir="rtl">المتخصصة للحلول الطبية <span class="text-xs">ذ.م.م</span></h4>
             </div>
        </div>

        <!-- Copyright -->
        <div class="text-gray-500 text-sm font-medium">
            <p>&copy; 2025 SMS QATAR are the property of their respective owners.</p>
        </div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script src="https://unpkg.com/@studio-freight/lenis@1.0.34/dist/lenis.min.js"></script>
<script>
      document.addEventListener('DOMContentLoaded', function() {
            // --- BACKGROUND 3D ATOMS ANIMATION ---
            const canvas = document.getElementById('atom-bg');
            const ctx = canvas.getContext('2d');
            let particles = [];
            // Reduced count for better performance & less clutter given the larger 3D look
            const particleCount = 25; 
            
            // Vibrant colors from the requested image style
            const colors = [
                { main: '#FF4136', light: '#ff726b', shadow: '#b30c00' }, // Red
                { main: '#2ECC40', light: '#5fe06e', shadow: '#1a7a24' }, // Green
                { main: '#0074D9', light: '#4ea1f2', shadow: '#00407a' }, // Blue
                { main: '#B10DC9', light: '#d15beb', shadow: '#6a067a' }, // Purple
                { main: '#FF851B', light: '#ffad61', shadow: '#b35200' }, // Orange
                { main: '#FFDC00', light: '#ffe96b', shadow: '#998300' }, // Yellow
                { main: '#00CED1', light: '#45eff2', shadow: '#007a7c' }  // Teal
            ];

            function resizeCanvas() {
                canvas.width = window.innerWidth;
                canvas.height = window.innerHeight;
            }

            window.addEventListener('resize', resizeCanvas);
            resizeCanvas();

            class Atom {
                constructor() {
                    this.init();
                }

                init() {
                    this.radius = Math.random() * 8 + 8; // Radius 8-16px
                    this.x = Math.random() * (canvas.width - this.radius * 2) + this.radius;
                    this.y = Math.random() * (canvas.height - this.radius * 2) + this.radius;
                    this.vx = (Math.random() - 0.5) * 1.5; // Velocity
                    this.vy = (Math.random() - 0.5) * 1.5;
                    this.mass = this.radius; // Mass proportional to radius
                    
                    // Pick random color scheme
                    this.colorScheme = colors[Math.floor(Math.random() * colors.length)];
                }

                update(particles) {
                    this.x += this.vx;
                    this.y += this.vy;

                    // Wall collision
                    if (this.x - this.radius < 0) { this.x = this.radius; this.vx *= -1; }
                    if (this.x + this.radius > canvas.width) { this.x = canvas.width - this.radius; this.vx *= -1; }
                    if (this.y - this.radius < 0) { this.y = this.radius; this.vy *= -1; }
                    if (this.y + this.radius > canvas.height) { this.y = canvas.height - this.radius; this.vy *= -1; }

                    // Particle Collision (Elastic)
                    for (let particle of particles) {
                        if (this === particle) continue;

                        // Distance check
                        let dx = this.x - particle.x;
                        let dy = this.y - particle.y;
                        let distance = Math.sqrt(dx * dx + dy * dy);

                        if (distance < this.radius + particle.radius) {
                            // Resolve overlap
                            let overlap = (this.radius + particle.radius - distance) / 2;
                            let nx = dx / distance; // Normal vector x
                            let ny = dy / distance; // Normal vector y
                            
                            this.x += nx * overlap;
                            this.y += ny * overlap;
                            particle.x -= nx * overlap;
                            particle.y -= ny * overlap;

                            // Resolve Velocity (1D elastic collision along normal)
                            // v1' = v1 - 2*m2/(m1+m2) * dot(v1-v2, n) * n
                            
                            let vCollision = { x: particle.vx - this.vx, y: particle.vy - this.vy };
                            let vDotNorm = vCollision.x * nx + vCollision.y * ny;

                            if (vDotNorm > 0) continue; // Moving apart already

                            let impulse = (2 * vDotNorm) / (this.mass + particle.mass);
                            
                            this.vx += impulse * particle.mass * nx;
                            this.vy += impulse * particle.mass * ny;
                            particle.vx -= impulse * this.mass * nx;
                            particle.vy -= impulse * this.mass * ny;
                        }
                    }
                }

                draw() {
                    // Create 3D effect with radial gradient
                    // Light source at top-left (-radius/3, -radius/3)
                    let gradient = ctx.createRadialGradient(
                        this.x - this.radius / 3, 
                        this.y - this.radius / 3, 
                        this.radius / 5, 
                        this.x, 
                        this.y, 
                        this.radius
                    );
                    
                    gradient.addColorStop(0, this.colorScheme.light);
                    gradient.addColorStop(0.3, this.colorScheme.main);
                    gradient.addColorStop(1, this.colorScheme.shadow);

                    ctx.fillStyle = gradient;
                    ctx.beginPath();
                    ctx.arc(this.x, this.y, this.radius, 0, Math.PI * 2);
                    ctx.fill();
                    
                    // Add subtle shadow halo for depth
                    ctx.shadowColor = "rgba(0,0,0,0.1)";
                    ctx.shadowBlur = 10;
                    ctx.shadowOffsetX = 2;
                    ctx.shadowOffsetY = 2;
                    ctx.stroke(); // trigger shadow
                    ctx.shadowColor = "transparent"; // reset
                }
            }

            function initBackground() {
                particles = [];
                for (let i = 0; i < particleCount; i++) {
                    particles.push(new Atom());
                }
            }

            function animateBackground() {
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                
                // Draw bonds between close atoms (to look like molecules)
                for (let i = 0; i < particles.length; i++) {
                    for (let j = i + 1; j < particles.length; j++) {
                        let dx = particles[i].x - particles[j].x;
                        let dy = particles[i].y - particles[j].y;
                        let dist = Math.sqrt(dx * dx + dy * dy);
                        
                        // Draw connection if close but not too close (avoid drawing over collisions too much)
                        if (dist < 150) {
                            ctx.beginPath();
                            ctx.strokeStyle = "rgba(100, 100, 100, 0.15)";
                            ctx.lineWidth = 3;
                            ctx.moveTo(particles[i].x, particles[i].y);
                            ctx.lineTo(particles[j].x, particles[j].y);
                            ctx.stroke();
                        }
                    }
                }

                for (let i = 0; i < particles.length; i++) {
                    particles[i].update(particles);
                    particles[i].draw();
                }
                requestAnimationFrame(animateBackground);
            }

            initBackground();
            animateBackground();

            // --- HEADER & SLIDER SCRIPTS ---
            const header = document.getElementById('main-header');
            const topBar = document.getElementById('top-bar');
            const navbar = document.getElementById('navbar');
            const logoImg = document.getElementById('logo-img');

            window.addEventListener('scroll', () => {
                const navLinks = document.querySelectorAll('.nav-link');
                
                if (window.scrollY > 100) {
                    header.classList.remove('absolute');
                    header.classList.add('fixed', 'top-0', 'animate-slideDown', 'shadow-md');
                    
                    // Navbar Style (Sticky)
                    navbar.classList.add('bg-white', 'py-3');
                    navbar.classList.remove('bg-transparent', 'py-5');
                    
                    // Logo Style
                    logoImg.classList.add('h-10');
                    logoImg.classList.remove('h-12', 'brightness-0', 'invert');
                    
                    // Link Styles
                    navLinks.forEach(link => {
                        link.classList.remove('text-white', 'text-white/90');
                        link.classList.add('text-dark');
                    });
                    
                    // Mobile Menu Toggle Color
                    menuToggle.classList.remove('text-white');
                    menuToggle.classList.add('text-dark');

                    if(topBar) topBar.classList.add('hidden');

                } else {
                    header.classList.add('absolute');
                    header.classList.remove('fixed', 'top-0', 'animate-slideDown', 'shadow-md');
                    
                    // Navbar Style (Transparent)
                    navbar.classList.add('bg-transparent', 'py-5');
                    navbar.classList.remove('bg-white', 'py-3');
                    
                    // Logo Style
                    logoImg.classList.add('h-12', 'brightness-0', 'invert');
                    logoImg.classList.remove('h-10');
                    
                     // Link Styles
                    navLinks.forEach(link => {
                        link.classList.add('text-white');
                        link.classList.remove('text-dark');
                    });

                    // Mobile Menu Toggle Color
                    menuToggle.classList.add('text-white');
                    menuToggle.classList.remove('text-dark');

                    if(topBar) topBar.classList.remove('hidden');
                }
            });

            const menuToggle = document.getElementById('menu-toggle');
            const menuClose = document.getElementById('menu-close');
            const mobileMenu = document.getElementById('mobile-menu');
            const menuOverlay = document.getElementById('menu-overlay');

            function toggleMenu() {
                mobileMenu.classList.toggle('open');
                menuOverlay.classList.toggle('hidden');
                document.body.classList.toggle('overflow-hidden');
            }

            menuToggle.addEventListener('click', toggleMenu);
            menuClose.addEventListener('click', toggleMenu);
            menuOverlay.addEventListener('click', toggleMenu);

            const slides = document.querySelectorAll('.slide');
            const dots = document.querySelectorAll('#slider-dots button');
            let currentSlide = 0;
            const slideInterval = 6000;

            function showSlide(index) {
                slides[currentSlide].classList.remove('active');
                dots[currentSlide].classList.remove('bg-primary');
                dots[currentSlide].classList.add('bg-dark/20');
                currentSlide = index;
                slides[currentSlide].classList.add('active');
                dots[currentSlide].classList.add('bg-primary');
                dots[currentSlide].classList.remove('bg-dark/20');
            }

            function nextSlide() {
                let next = (currentSlide + 1) % slides.length;
                if (slides[next]) showSlide(next);
            }
            setInterval(nextSlide, slideInterval);

            dots.forEach((dot, index) => {
                dot.addEventListener('click', () => {
                    showSlide(index);
                });
            });

            // --- MAIN HERO SLIDER INIT ---
            var mainHeroSwiper = new Swiper(".mainHeroSwiper", {
                effect: "fade",
                fadeEffect: { crossFade: true },
                speed: 1000,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                loop: true,
                allowTouchMove: false, // Cleaner for desktop
            });

            // --- PRODUCTS SWIPER INIT ---
            // --- PRODUCTS SWIPER INIT ---
            var swiperProducts = new Swiper(".mySwiper", {
                slidesPerView: 1,
                spaceBetween: 30,
                loop: true,
                autoplay: {
                    delay: 3000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                breakpoints: {
                    640: { slidesPerView: 2 },
                    1024: { slidesPerView: 4 },
                },
            });

            // --- PARTNERS SWIPER INIT ---
            var swiperPartners = new Swiper(".mySwiperPartners", {
                slidesPerView: 2,
                spaceBetween: 20,
                loop: true,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                breakpoints: {
                    640: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 4,
                    },
                    1024: {
                        slidesPerView: 5,
                    },
                },
            });

            // --- SCROLL ANIMATIONS (Reveal) ---
            const observerOptions = {
                root: null,
                rootMargin: '0px',
                threshold: 0.1
            };

            const observer = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('active');
                        // Optional: Stop observing once active if you want it to happen only once
                        // observer.unobserve(entry.target); 
                    }
                });
            }, observerOptions);

            const revealElements = document.querySelectorAll('.reveal');
            revealElements.forEach(el => observer.observe(el));

            // --- PARALLAX EFFECT ---
            window.addEventListener('scroll', function() {
                const scrolled = window.pageYOffset;
                
                // Slow background patterns
                const patterns = document.querySelectorAll('.bg-pattern-cross, .bg-pattern-dots');
                patterns.forEach(pattern => {
                   pattern.style.transform = `translateY(${scrolled * 0.1}px)`;
                });

                // Floating Shapes (move faster/slower)
                const shapes = document.querySelectorAll('.floating-shape');
                shapes.forEach((shape, index) => {
                    const speed = (index + 1) * 0.05;
                    shape.style.transform = `translateY(${scrolled * speed}px) rotate(${scrolled * 0.02}deg)`;
                });
            });
        });

        // --- LENIS SMOOTH SCROLL ---
        const lenis = new Lenis({
            duration: 1.2,
            easing: (t) => Math.min(1, 1.001 - Math.pow(2, -10 * t)),
            direction: 'vertical',
            gestureDirection: 'vertical',
            smooth: true,
            mouseMultiplier: 1,
            smoothTouch: false,
            touchMultiplier: 2,
        });

        function raf(time) {
            lenis.raf(time);
            requestAnimationFrame(raf);
        }

        requestAnimationFrame(raf);
    </script>