<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS - Specialized Medical Solutions</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="Assets/Css/Style.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts: Poppins -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
      <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#b9234e',
                        secondary: '#ffffff',
                        dark: '#232323',
                        grayish: '#666666',
                    },
                    fontFamily: {
                        poppins: ['Poppins', 'sans-serif'],
                    },
                    keyframes: {
                        slideDown: {
                            '0%': { transform: 'translateY(-100%)' },
                            '100%': { transform: 'translateY(0)' },
                        },
                        // Diagonal 3D Helix Animation
                        // Nodes move diagonally to simulate rotation around a tilted axis
                        dnaNodeA: {
                            '0%, 100%': { transform: 'translate(-35px, -20px) scale(0.65)', opacity: '0.25', zIndex: '1' },
                            '50%': { transform: 'translate(35px, 20px) scale(1.15)', opacity: '0.9', zIndex: '20' },
                        },
                        dnaNodeB: {
                            '0%, 100%': { transform: 'translate(35px, 20px) scale(1.15)', opacity: '0.9', zIndex: '20' },
                            '50%': { transform: 'translate(-35px, -20px) scale(0.65)', opacity: '0.25', zIndex: '1' },
                        },
                        dnaBarDiagonal: {
                            '0%, 50%, 100%': { transform: 'scaleX(0) rotate(30deg)', opacity: '0' },
                            '25%, 75%': { transform: 'scaleX(1) rotate(30deg)', opacity: '0.25' }
                        },
                        kenBurns: {
                            '0%': { transform: 'scale(1)' },
                            '100%': { transform: 'scale(1.1)' },
                        }
                    },
                    animation: {
                        slideDown: 'slideDown 0.4s ease-out forwards',
                        dnaNodeA: 'dnaNodeA 3.5s ease-in-out infinite',
                        dnaNodeB: 'dnaNodeB 3.5s ease-in-out infinite',
                        dnaBar: 'dnaBarDiagonal 3.5s ease-in-out infinite',
                        kenBurns: 'kenBurns 10s ease-out infinite alternate',
                    }
                }
            }
        }
    </script>
  
    
</head>
<body>
      <canvas id="atom-bg"></canvas>
  <!-- HEADER START -->
    <header id="main-header" class="absolute top-0 left-0 w-full z-[1000] header-transition">
        
        <!-- Top Contact Bar -->
        <div id="top-bar" class="bg-primary text-white py-2.5 hidden md:block">
            <div class="container mx-auto max-w-7xl px-6 flex justify-between items-center text-sm font-medium">
                <div class="flex items-center gap-8">
                    <span class="flex items-center gap-2">
                        <i class="fas fa-map-marker-alt text-white/80"></i> Al Jazira Arabiya St, Doha, Qatar
                    </span>
                    <span class="flex items-center gap-2">
                        <i class="fas fa-envelope text-white/80"></i> info@smsqatar.org 
                    </span>
                    <span class="flex items-center gap-2">
                        <i class="fas fa-phone text-white/80"></i> +974-44620491 
                    </span>
                </div>
                <div>
                    <a href="#" class="border border-white px-5 py-1.5 rounded-md hover:bg-white hover:text-primary transition-all">
                        Make Appointment
                    </a>
                </div>
            </div>
        </div>

        <!-- Main Navigation Bar -->
        <nav id="navbar" class="bg-transparent py-5 header-transition z-[1000]">
            <div class="container mx-auto max-w-7xl px-6 flex justify-between items-center">
                
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="#" class="flex items-center">
                        <!-- Placeholder logo image - replace src with your real logo path -->
                        <img id="logo-img" src="Assets/Images/logoMain.svg" alt="Specialized Medical Solutions" class="h-12 w-auto header-transition object-contain brightness-0 invert">
                    </a>
                </div>

                <!-- Desktop Nav Links -->
                <div class="hidden lg:flex items-center gap-6">
                    <ul class="flex items-center gap-6 list-none m-0 p-0 text-[14px] font-semibold tracking-wide">
                        <li><a href="index.php" class="nav-link text-white hover:text-primary transition-colors">Home</a></li>
                        <li><a href="about_us.php" class="nav-link text-white/90 hover:text-white transition-colors">About Us</a></li>
                        <li><a href="healthcare_technology.php" class="nav-link text-white/90 hover:text-white transition-colors">Healthcare Technology</a></li>
                        <li><a href="management_consultancy.php" class="nav-link text-white/90 hover:text-white transition-colors">Management & Consultancy</a></li>
                        <li><a href="products.php" class="nav-link text-white/90 hover:text-white transition-colors">Products</a></li>
                        <li><a href="blogs.php" class="nav-link text-white/90 hover:text-white transition-colors">Our Blogs</a></li>
                        <li><a href="careers.php" class="nav-link text-white/90 hover:text-white transition-colors">Careers</a></li>
                    </ul>
                    
                    <!-- Search Icon (Hidden for space or kept small) -->
                    <!-- <div class="pl-4 border-l border-white/20">
                        <button class="nav-link text-white hover:text-primary transition-colors">
                            <i class="fas fa-search text-lg"></i>
                        </button>
                    </div> -->
                    <!-- Keep Contact Us as a Button or Link? Standard Nav has it. I'll add it to the list or a button. "Create a menu with"... let's add it to end of list to be safe -->
                    <a href="contact_us.php" class="nav-link bg-primary text-white px-4 py-2 rounded-md hover:bg-white hover:text-primary transition-all text-sm">Contact Us</a>

                </div>

                <!-- Mobile Hamburger Button -->
                <button id="menu-toggle" class="lg:hidden text-2xl text-white p-2 focus:outline-none">
                    <i class="fas fa-bars"></i>
                </button>

            </div>
        </nav>
    </header>

    <!-- MOBILE MENU SIDEBAR -->
    <div id="mobile-menu" class="fixed top-0 right-0 w-[300px] h-full bg-white z-[2000] shadow-2xl flex flex-col p-8 lg:hidden">
        <button id="menu-close" class="self-end text-2xl mb-8">
            <i class="fas fa-times"></i>
        </button>
        <ul class="flex flex-col gap-4 text-base font-semibold">
            <li><a href="index.php" class="text-primary">Home</a></li>
            <li><a href="about_us.php" class="text-dark hover:text-primary">About Us</a></li>
            <li><a href="healthcare_technology.php" class="text-dark hover:text-primary">Healthcare Technology</a></li>
            <li><a href="management_consultancy.php" class="text-dark hover:text-primary">Management & Consultancy</a></li>
            <li><a href="products.php" class="text-dark hover:text-primary">Products</a></li>
            <li><a href="blogs.php" class="text-dark hover:text-primary">Our Blogs</a></li>
            <li><a href="careers.php" class="text-dark hover:text-primary">Careers</a></li>
            <li><a href="contact_us.php" class="text-dark hover:text-primary">Contact Us</a></li>
        </ul>
        <div class="mt-auto border-t pt-6">
            <a href="#" class="block text-center bg-primary text-white py-3 rounded font-bold">Appointment</a>
        </div>
    </div>
    <!-- Mobile Menu Overlay -->
    <div id="menu-overlay" class="fixed inset-0 bg-black/50 z-[1999] hidden"></div>