<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="relative h-[40vh] min-h-[350px] flex items-center overflow-hidden">
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?auto=format&fit=crop&q=80&w=2000" alt="Background" class="w-full h-full object-cover object-center">
    </div>
    <div class="absolute top-0 left-0 h-full w-full bg-gradient-to-r from-[#981B46]/95 via-[#981B46]/80 to-transparent"></div>
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2 reveal">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <span class="text-white">Healthcare Technology</span>
        </div>
        <h1 class="text-5xl md:text-6xl font-bold text-white tracking-wide reveal reveal-delay-100">
            Healthcare Technology
        </h1>
    </div>
</section>

<!-- CONTENT -->
<section class="py-20 relative">
    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        
        <!-- INTRO -->
        <div class="text-center mb-20 max-w-3xl mx-auto">
            <h2 class="text-3xl font-bold text-dark mb-6">Comprehensive Healthcare Solutions</h2>
            <p class="text-gray-500 leading-relaxed">
                We bring you innovative technologies in the field of clinical laboratory testing, life science research, and advanced medical IT solutions from the world’s prominent manufacturers.
            </p>
        </div>

        <!-- SECTION 1: MEDICAL IT SOLUTIONS (Redesigned) -->
        <div class="mb-24 bg-gray-50 rounded-[3rem] p-8 md:p-12 relative overflow-hidden">
            <!-- Decorative Blur -->
            <div class="absolute top-0 right-0 w-96 h-96 bg-[#981B46]/5 rounded-full blur-3xl -mr-32 -mt-32 pointer-events-none"></div>

                <!-- Full Width Grid Listing -->
                <div class="w-full">
                    <div class="flex items-center gap-4 mb-8">
                        <span class="bg-[#981B46]/10 text-[#981B46] px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider">IT Services</span>
                        <h3 class="text-3xl font-bold text-dark">Medical IT Solutions</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 relative z-10">
                        <!-- Card 1: Radiology -->
                        <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100">
                            <!-- Hover Background Image -->
                            <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                <img src="https://images.unsplash.com/photo-1516549655169-df83a0929517?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                                <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                            </div>
                            
                            <div class="relative z-10">
                                <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                                    <i class="fas fa-x-ray"></i>
                                </div>
                                <h4 class="text-xl font-bold text-dark mb-2 group-hover:text-white transition-colors">Radiology Solutions</h4>
                                <p class="text-sm text-gray-500 leading-relaxed mb-4 group-hover:text-white transition-colors">PACS, RIS, CIS, and LIS systems to streamline your radiology and imaging workflows.</p>
                                <div class="w-12 h-1 bg-gray-200 group-hover:bg-white transition-colors"></div>
                            </div>
                        </div>

                        <!-- Card 2: Gastroenterology -->
                        <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100">
                            <!-- Hover Background Image -->
                            <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                <img src="https://images.unsplash.com/photo-1579684385127-1ef15d508118?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                                <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                            </div>
                             
                            <div class="relative z-10">
                                <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                                    <i class="fas fa-notes-medical"></i>
                                </div>
                                <h4 class="text-xl font-bold text-dark mb-2 group-hover:text-white transition-colors">Gastroenterology</h4>
                                <p class="text-sm text-gray-500 leading-relaxed mb-4 group-hover:text-white transition-colors">Electronic nursing record & image management solutions representing EndoSoft.</p>
                                <div class="w-12 h-1 bg-gray-200 group-hover:bg-white transition-colors"></div>
                            </div>
                        </div>

                        <!-- Card 3: Ophthalmic -->
                        <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100">
                             <!-- Hover Background Image -->
                            <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                                <img src="https://images.unsplash.com/photo-1579154204601-01588f351e67?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                                <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                            </div>

                            <div class="relative z-10">
                                <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                                    <i class="fas fa-eye"></i>
                                </div>
                                <h4 class="text-xl font-bold text-dark mb-2 group-hover:text-white transition-colors">Ophthalmic Solutions</h4>
                                <p class="text-sm text-gray-500 leading-relaxed mb-4 group-hover:text-white transition-colors">Comprehensive eye care data management (EMR, PACS) representing ifa systems.</p>
                                <div class="w-12 h-1 bg-gray-200 group-hover:bg-white transition-colors"></div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>

        <!-- SECTION 2: MEDICAL PRODUCTS -->
        <div class="mb-24">
            <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 bg-[#981B46]/10 rounded-xl flex items-center justify-center text-[#981B46] text-xl">
                    <i class="fas fa-briefcase-medical"></i>
                </div>
                <h3 class="text-2xl font-bold text-dark">Medical Products</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Card 1: Imaging -->
                <div class="group relative bg-white p-6 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full flex flex-col justify-between">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1551076805-e1869033e561?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>
                    
                    <div class="relative z-10">
                        <i class="fas fa-x-ray text-3xl text-[#981B46] group-hover:text-white mb-4 transition-colors"></i>
                        <h4 class="font-bold text-lg mb-2 text-dark group-hover:text-white transition-colors">Imaging Division</h4>
                        <p class="text-sm text-gray-500 group-hover:text-white/90 transition-colors">Advanced digital solutions and combined modalities.</p>
                        <div class="w-8 h-1 bg-gray-200 group-hover:bg-white transition-colors mt-4"></div>
                    </div>
                </div>

                <!-- Card 2: General Equipment -->
                <div class="group relative bg-white p-6 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full flex flex-col justify-between">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1581594693702-fbdc51b2763b?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>
                    
                    <div class="relative z-10">
                        <i class="fas fa-stethoscope text-3xl text-[#981B46] group-hover:text-white mb-4 transition-colors"></i>
                        <h4 class="font-bold text-lg mb-2 text-dark group-hover:text-white transition-colors">General Equipment</h4>
                        <p class="text-sm text-gray-500 group-hover:text-white/90 transition-colors">High-tech clinical products and solutions.</p>
                        <div class="w-8 h-1 bg-gray-200 group-hover:bg-white transition-colors mt-4"></div>
                    </div>
                </div>

                <!-- Card 3: Consumables -->
                <div class="group relative bg-white p-6 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full flex flex-col justify-between">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1583324113626-70df0f4deaab?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>
                    
                    <div class="relative z-10">
                        <i class="fas fa-band-aid text-3xl text-[#981B46] group-hover:text-white mb-4 transition-colors"></i>
                        <h4 class="font-bold text-lg mb-2 text-dark group-hover:text-white transition-colors">Consumables</h4>
                        <p class="text-sm text-gray-500 group-hover:text-white/90 transition-colors">Widest range of high-quality medical consumables.</p>
                        <div class="w-8 h-1 bg-gray-200 group-hover:bg-white transition-colors mt-4"></div>
                    </div>
                </div>

                <!-- Card 4: Hospital Furniture -->
                <div class="group relative bg-white p-6 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full flex flex-col justify-between">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1519494026892-80bbd2d6fd0d?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>
                    
                    <div class="relative z-10">
                        <i class="fas fa-bed text-3xl text-[#981B46] group-hover:text-white mb-4 transition-colors"></i>
                        <h4 class="font-bold text-lg mb-2 text-dark group-hover:text-white transition-colors">Hospital Furniture</h4>
                        <p class="text-sm text-gray-500 group-hover:text-white/90 transition-colors">Advanced technological furniture solutions.</p>
                        <div class="w-8 h-1 bg-gray-200 group-hover:bg-white transition-colors mt-4"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- SECTION 3: LIFE SCIENCE -->
        <div class="mb-24">
            <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 bg-[#981B46]/10 rounded-xl flex items-center justify-center text-[#981B46] text-xl">
                    <i class="fas fa-dna"></i>
                </div>
                <h3 class="text-2xl font-bold text-dark">Life Science</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Card 1: Norgen -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1579165466741-7f35a4755657?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>

                    <div class="relative z-10 h-full flex flex-col">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-microscope"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Norgen Biotek</h4>
                        <p class="text-gray-500 leading-relaxed mb-6 group-hover:text-white/90 transition-colors flex-grow">
                             Unique platform technology based on proprietary resin/matrix for purification, concentration, and clean-up of DNA, RNA, microRNA, and proteins.
                        </p>
                    </div>
                </div>
                
                 <!-- Card 2: Operation Areas (New Split Card) -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full flex flex-col">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1532094349884-543bc11b234d?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>
                    
                    <div class="relative z-10 flex-grow flex flex-col">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-search-location"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Operation Areas</h4>
                        <ul class="space-y-2 text-sm text-gray-500 group-hover:text-white/90 transition-colors mt-auto">
                             <li class="flex items-center gap-2"><i class="fas fa-dot-circle text-[10px]"></i> University Research Labs</li>
                             <li class="flex items-center gap-2"><i class="fas fa-dot-circle text-[10px]"></i> Molecular Genetics</li>
                             <li class="flex items-center gap-2"><i class="fas fa-dot-circle text-[10px]"></i> Stem Cell Research</li>
                             <li class="flex items-center gap-2"><i class="fas fa-dot-circle text-[10px]"></i> Proteomics & Forensics</li>
                             <li class="flex items-center gap-2"><i class="fas fa-dot-circle text-[10px]"></i> Diagnostics</li>
                        </ul>
                    </div>
                </div>

                <!-- Card 3: Services -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full">
                     <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1581093458791-9f3c3900df4b?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>

                    <div class="relative z-10 h-full flex flex-col">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-tools"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Support & Services</h4>
                         <ul class="space-y-4 group-hover:text-white transition-colors mt-auto">
                            <li class="flex gap-4 items-start">
                                <i class="fas fa-snowflake mt-1"></i>
                                <div>
                                    <strong class="block text-sm">Cold Chain Management</strong>
                                </div>
                            </li>
                             <li class="flex gap-4 items-start">
                                <i class="fas fa-ruler-combined mt-1"></i>
                                <div>
                                    <strong class="block text-sm">Technical Calibration</strong>
                                </div>
                            </li>
                             <li class="flex gap-4 items-start">
                                <i class="fas fa-sync mt-1"></i>
                                <div>
                                    <strong class="block text-sm">Maintenance & Support</strong>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- SECTION 4: LABORATORY PRODUCTS -->
        <div class="mb-24">
             <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 bg-[#981B46]/10 rounded-xl flex items-center justify-center text-[#981B46] text-xl">
                    <i class="fas fa-flask"></i>
                </div>
                <h3 class="text-2xl font-bold text-dark">Laboratory Products</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Card 1: Automation -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1518152006812-edab29bca698?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>

                    <div class="relative z-10">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-robot"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Lab Automation</h4>
                        <ul class="space-y-2 text-sm text-gray-500 group-hover:text-white/90 transition-colors">
                            <li>• Automated Lab Analyzers</li>
                            <li>• Liquid Handling Robotics</li>
                            <li>• RTPCR Systems</li>
                            <li>• Flow Cytometer</li>
                             <li>• Microarrays & DNA Sequencers</li>
                        </ul>
                    </div>
                </div>

                <!-- Card 2: Reagents -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1579165466950-84478370dd59?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>

                    <div class="relative z-10">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-vial"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Reagents & Consumables</h4>
                         <ul class="space-y-2 text-sm text-gray-500 group-hover:text-white/90 transition-colors">
                            <li>• Bio-chemistry Reagent Packs</li>
                            <li>• Quality Control Sera</li>
                            <li>• Culture Medias & Petry Dishes</li>
                            <li>• Transport Medias & Pipettes</li>
                             <li>• Plastic Containers & Glassware</li>
                        </ul>
                    </div>
                </div>

                <!-- Card 3: Furniture -->
                <div class="group relative bg-white p-8 rounded-2xl shadow-xl transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl overflow-hidden border border-gray-100 h-full">
                    <!-- Hover Background Image -->
                    <div class="absolute inset-0 z-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <img src="https://images.unsplash.com/photo-1517164850305-99a3e65bb47e?auto=format&fit=crop&q=80" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-[#981B46]/90 mix-blend-multiply"></div>
                    </div>

                    <div class="relative z-10">
                        <div class="w-16 h-16 bg-[#981B46]/10 rounded-2xl flex items-center justify-center text-[#981B46] text-3xl mb-6 group-hover:bg-white group-hover:text-[#981B46] group-hover:scale-110 transition-all duration-300 shadow-sm">
                            <i class="fas fa-chairs"></i>
                        </div>
                        <h4 class="text-xl font-bold text-dark mb-4 group-hover:text-white transition-colors">Furniture & Storage</h4>
                         <ul class="space-y-2 text-sm text-gray-500 group-hover:text-white/90 transition-colors">
                            <li>• Laboratory Benches & Fume Cupboards</li>
                            <li>• Co2 Incubators & Laminar Flow Stations</li>
                            <li>• Biosafety Cabinets</li>
                            <li>• Refrigerators, Freezers & Cold Rooms</li>
                             <li>• Liquid Nitrogen Tanks</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<?php include 'footer.php'; ?>
