<?php include 'header.php'; ?>


    <!-- HERO SECTION (Updated to Swipe Slider) -->
    <section class="relative w-full h-screen max-h-[900px] min-h-[700px] bg-[#0B1221] overflow-hidden">
        
        <!-- Swiper -->
        <div class="swiper mainHeroSwiper w-full h-full">
            <div class="swiper-wrapper">
                
                <!-- Slide 1: MRI Scanner -->
                <div class="swiper-slide relative w-full h-full">
                    <!-- Background -->
                    <div class="absolute inset-0 bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)]"></div>
                    
                    <div class="container mx-auto max-w-7xl px-6 h-full relative z-10 grid grid-cols-1 lg:grid-cols-12 items-center">
                        
                        <!-- Left Content -->
                        <div class="lg:col-span-4 text-white pt-20 lg:pt-0 relative z-20">
                            <div class="flex items-center gap-4 mb-8">
                                <i class="fas fa-square text-white"></i>
                                <span class="font-bold text-xl tracking-wide">SMS Qatar</span>
                            </div>
                            <h1 class="text-5xl lg:text-7xl font-light leading-tight mb-6">
                                Advanced<br>
                                <span class="font-bold">Imaging</span><br>
                                Solutions
                            </h1>
                            <p class="text-white/80 text-lg mb-8 max-w-md">Experience crystal clear diagnostics with our state-of-the-art MRI technology.</p>
                            
                            <div class="flex items-center gap-12 mt-12">
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Model</span>
                                    <span class="block font-bold text-xl">Magnetom 2025</span>
                                </div>
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Availability</span>
                                    <span class="block font-bold text-xl">In Stock</span>
                                </div>
                            </div>
                        </div>

                        <!-- Center Image (3D Product) -->
                        <div class="lg:col-span-5 relative h-full flex items-center justify-center">
                            <!-- Product Glow -->
                            <div class="absolute w-[500px] h-[500px] bg-white/20 blur-[100px] rounded-full pointer-events-none"></div>
                            
                            <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=800" 
                                 class="relative z-10 w-full max-w-[500px] object-contain drop-shadow-2xl animate-float filter brightness-110 contrast-125"
                                 alt="MRI Scanner">
                        </div>

                        <!-- Right Navigation Preview -->
                        <div class="lg:col-span-3 hidden lg:flex flex-col justify-center gap-6 pl-12 h-screen border-l border-white/10 bg-black/10 backdrop-blur-sm">
                            <h4 class="text-white/50 uppercase text-sm mb-4">Next Products</h4>
                            
                            <!-- Next Item 1 -->
                            <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideNext()">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">Robotic Arm</span>
                                    <span class="text-white/40 text-xs">Surgical Precision</span>
                                </div>
                            </div>

                            <!-- Next Item 2 -->
                            <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideTo(2)">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1579154204601-01588f351e67?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">Microscope</span>
                                    <span class="text-white/40 text-xs">Lab Research</span>
                                </div>
                            </div>
                        </div>

                    </div>
                    
                    <!-- Bottom Info -->
                    <div class="absolute bottom-10 left-0 w-full px-6 container mx-auto flex justify-between text-white/40 text-xs uppercase tracking-widest z-20">
                        <span>Best Medical Tech 2025</span>
                        <span>Doha, Qatar &bull; 10:00 AM</span>
                    </div>
                </div>

                <!-- Slide 2: Robotic Arm -->
                <div class="swiper-slide relative w-full h-full">
                    <!-- Background -->
                    <div class="absolute inset-0 bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)]"></div> <!-- Maroon Theme -->
                    
                    <div class="container mx-auto max-w-7xl px-6 h-full relative z-10 grid grid-cols-1 lg:grid-cols-12 items-center">
                        <!-- Left Content -->
                        <div class="lg:col-span-4 text-white pt-20 lg:pt-0 relative z-20">
                            <div class="flex items-center gap-4 mb-8">
                                <i class="fas fa-robot text-white"></i>
                                <span class="font-bold text-xl tracking-wide">SMS Qatar</span>
                            </div>
                            <h1 class="text-5xl lg:text-7xl font-light leading-tight mb-6">
                                Precision<br>
                                <span class="font-bold">Robotics</span><br>
                                Systems
                            </h1>
                            <p class="text-white/80 text-lg mb-8 max-w-md">Enhancing surgical outcomes with millimeter-level precision and stability.</p>
                            
                            <div class="flex items-center gap-12 mt-12">
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Series</span>
                                    <span class="block font-bold text-xl">DaVinci X</span>
                                </div>
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Status</span>
                                    <span class="block font-bold text-xl">Operaional</span>
                                </div>
                            </div>
                        </div>

                        <!-- Center Image -->
                        <div class="lg:col-span-5 relative h-full flex items-center justify-center">
                             <div class="absolute w-[500px] h-[500px] bg-white/10 blur-[100px] rounded-full pointer-events-none"></div>
                            <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=800" 
                                 class="relative z-10 w-full max-w-[500px] object-contain drop-shadow-2xl animate-float filter brightness-110 contrast-125"
                                 alt="Robotic Arm">
                        </div>
                        
                         <!-- Right Navigation -->
                        <div class="lg:col-span-3 hidden lg:flex flex-col justify-center gap-6 pl-12 h-screen border-l border-white/10 bg-black/10 backdrop-blur-sm">
                            <h4 class="text-white/50 uppercase text-sm mb-4">Next Products</h4>
                            <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideNext()">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1579154204601-01588f351e67?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">Microscope</span>
                                    <span class="text-white/40 text-xs">Lab Research</span>
                                </div>
                            </div>
                             <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideTo(0)">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">MRI Scanner</span>
                                    <span class="text-white/40 text-xs">Imaging</span>
                                </div>
                            </div>
                        </div>
                    </div>
                     <!-- Bottom Info -->
                    <div class="absolute bottom-10 left-0 w-full px-6 container mx-auto flex justify-between text-white/40 text-xs uppercase tracking-widest z-20">
                        <span>Best Medical Tech 2025</span>
                        <span>Doha, Qatar &bull; 10:00 AM</span>
                    </div>
                </div>

                <!-- Slide 3: Microscope -->
                <div class="swiper-slide relative w-full h-full">
                    <!-- Background -->
                    <div class="absolute inset-0 bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)]"></div> <!-- Maroon Theme -->
                    
                    <div class="container mx-auto max-w-7xl px-6 h-full relative z-10 grid grid-cols-1 lg:grid-cols-12 items-center">
                        <!-- Left Content -->
                        <div class="lg:col-span-4 text-white pt-20 lg:pt-0 relative z-20">
                            <div class="flex items-center gap-4 mb-8">
                                <i class="fas fa-vial text-white"></i>
                                <span class="font-bold text-xl tracking-wide">SMS Qatar</span>
                            </div>
                            <h1 class="text-5xl lg:text-7xl font-light leading-tight mb-6">
                                Lab<br>
                                <span class="font-bold">Research</span><br>
                                Excellence
                            </h1>
                            <p class="text-white/80 text-lg mb-8 max-w-md">High-fidelity optical systems for groundbreaking medical research.</p>
                            
                            <div class="flex items-center gap-12 mt-12">
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Zoom</span>
                                    <span class="block font-bold text-xl">2000x</span>
                                </div>
                                <div>
                                    <span class="block text-xs uppercase opacity-60">Type</span>
                                    <span class="block font-bold text-xl">Digital 4K</span>
                                </div>
                            </div>
                        </div>

                        <!-- Center Image -->
                        <div class="lg:col-span-5 relative h-full flex items-center justify-center">
                             <div class="absolute w-[500px] h-[500px] bg-white/10 blur-[100px] rounded-full pointer-events-none"></div>
                            <img src="https://images.unsplash.com/photo-1579154204601-01588f351e67?auto=format&fit=crop&q=80&w=800" 
                                 class="relative z-10 w-full max-w-[500px] object-contain drop-shadow-2xl animate-float filter brightness-110 contrast-125"
                                 alt="Microscope">
                        </div>

                         <!-- Right Navigation -->
                        <div class="lg:col-span-3 hidden lg:flex flex-col justify-center gap-6 pl-12 h-screen border-l border-white/10 bg-black/10 backdrop-blur-sm">
                            <h4 class="text-white/50 uppercase text-sm mb-4">Next Products</h4>
                             <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideTo(0)">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">MRI Scanner</span>
                                    <span class="text-white/40 text-xs">Imaging</span>
                                </div>
                            </div>
                            <div class="group cursor-pointer flex items-center gap-4 p-4 rounded-xl hover:bg-white/10 transition-all" onclick="document.querySelector('.mainHeroSwiper').swiper.slideTo(1)">
                                <div class="w-16 h-16 bg-white/5 rounded-lg p-2 overflow-hidden">
                                     <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-contain">
                                </div>
                                <div>
                                    <span class="block text-white font-bold group-hover:text-primary transition-colors">Robotic Arm</span>
                                    <span class="text-white/40 text-xs">Surgical</span>
                                </div>
                            </div>
                        </div>
                    </div>
                     <!-- Bottom Info -->
                    <div class="absolute bottom-10 left-0 w-full px-6 container mx-auto flex justify-between text-white/40 text-xs uppercase tracking-widest z-20">
                        <span>Best Medical Tech 2025</span>
                        <span>Doha, Qatar &bull; 10:00 AM</span>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- ABOUT / INTRO SECTION -->
    <section class="py-20 relative overflow-hidden">
        <!-- Floating Elements -->
        <div class="floating-shape shape-circle bottom-10 left-1/4"></div>

        <!-- Watermark Background -->
        <div class="watermark-text select-none text-center w-full">
            SPECIALIZED MEDICAL SOLUTIONS W.L.L
        </div>

        <div class="container mx-auto max-w-7xl px-6 relative z-10">
            <div class="flex flex-col lg:flex-row items-center gap-16">
                <!-- Image Collage Left -->
                <div class="w-full lg:w-1/2 relative reveal">
                    <div class="grid grid-cols-2 gap-4">
                        <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=600" class="rounded-lg shadow-lg w-full h-64 object-cover mt-12">
                         <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=600" class="rounded-lg shadow-lg w-full h-64 object-cover">
                    </div>
                    <!-- Central Circle Icon -->
                    <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-white p-2 rounded-full shadow-xl">
                        <div class="w-16 h-16 bg-primary rounded-full flex items-center justify-center text-white text-2xl animate-pulse">
                            <i class="fas fa-plus"></i>
                        </div>
                    </div>
                </div>

                <!-- Text Right -->
                <div class="w-full lg:w-1/2 reveal reveal-delay-200">
                    <h5 class="text-primary font-bold uppercase tracking-widest mb-2">About Us</h5>
                    <h2 class="text-4xl font-bold text-dark mb-6 leading-tight">Delivering Advanced Medical <br> Technology With Trusted Support</h2>
                    <p class="text-grayish mb-6 text-lg">
                        Specialized Medical Solutions (SMS) is a premier healthcare provider in Doha, Qatar. We bridge the gap between advanced technology and clinical support. Our philosophy is simple: <span class="text-primary font-bold italic">"Where technology and support shake hands."</span>
                    </p>
                    <a href="about_us.php" class="bg-primary text-white px-8 py-3 rounded text-sm font-bold uppercase hover:bg-dark transition-colors">View More</a>
                </div>
            </div>
        </div>
    </section>

    <!-- STATS BAR -->
    <section class="py-16 bg-primary text-white relative overflow-hidden bg-cover bg-center bg-no-repeat" style="background-image: url('Assets/Images/bg.webp');">
        <!-- Overlay removed -->
        <div class="absolute inset-0 bg-pattern-dots opacity-20"></div>
        <div class="container mx-auto max-w-7xl px-6 relative z-10">
            <div class="flex flex-wrap justify-center md:justify-between items-center gap-8 text-center md:text-left">
                <!-- Stat 1 -->
                <div class="flex items-center gap-4 reveal">
                     <i class="fas fa-globe-americas text-4xl opacity-80"></i>
                     <div>
                         <h3 class="text-3xl font-bold">+120</h3>
                         <p class="text-sm uppercase tracking-wide opacity-90">Worldwide Partners</p>
                     </div>
                </div>
                 <!-- Stat 2 -->
                <div class="flex items-center gap-4 reveal reveal-delay-100">
                     <i class="fas fa-tasks text-4xl opacity-80"></i>
                     <div>
                         <h3 class="text-3xl font-bold">+240</h3>
                         <p class="text-sm uppercase tracking-wide opacity-90">Projects Completed</p>
                     </div>
                </div>
                 <!-- Stat 3 -->
                <div class="flex items-center gap-4 reveal reveal-delay-200">
                     <i class="fas fa-handshake text-4xl opacity-80"></i>
                     <div>
                         <h3 class="text-3xl font-bold">+220</h3>
                         <p class="text-sm uppercase tracking-wide opacity-90">Happy Clients</p>
                     </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SERVICES SECTION (Redesigned based on Image) -->
    <section class="relative py-20 bg-[#981B46] text-white overflow-visible">
        <!-- Heartbeat Line Divider (Bottom) -->
        <div class="absolute bottom-0 left-0 w-full leading-[0] transform translate-y-[1px]">
             <svg class="w-full h-16 sm:h-24 text-gray-50 fill-current" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M0,80 L400,80 L420,20 L440,110 L460,40 L480,80 L1200,80 L1200,120 L0,120 Z" />
            </svg>
        </div>

        <div class="container mx-auto max-w-7xl px-6 relative z-10">
            <div class="flex flex-col lg:flex-row items-center lg:items-start gap-12">
                
                <!-- 1. Left Content (Text) -->
                <div class="lg:w-1/4 pt-10 text-center lg:text-left">
                    <h2 class="text-4xl font-bold leading-tight mb-6">World-Class <br> Healthcare <br> Solutions</h2>
                    <p class="text-white/80 mb-8 max-w-sm mx-auto lg:mx-0">
                        Bridging the gap between advanced technology and clinical support for better patient outcomes.
                    </p>
                    <a href="services.php" class="inline-flex items-center gap-2 bg-white text-[#981B46] px-6 py-3 rounded-full font-bold uppercase text-xs tracking-wider hover:bg-dark hover:text-white transition-all shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                        More Services <i class="fas fa-arrow-right"></i>
                    </a>
                </div>

                <!-- 2. Middle Content (Cards Grid) -->
                <div class="lg:w-1/2 w-full">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        
                        <!-- Card 1 -->
                        <div class="bg-white text-dark p-6 rounded-2xl shadow-xl transform transition-transform hover:-translate-y-2 cursor-pointer group">
                             <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center text-[#981B46] text-xl mb-4 group-hover:bg-[#981B46] group-hover:text-white transition-colors">
                                <i class="fas fa-microscope"></i>
                            </div>
                            <h3 class="font-bold text-lg mb-2">Healthcare Tech</h3>
                            <p class="text-xs text-gray-500 leading-relaxed">State-of-the-art medical equipment and integrated systems.</p>
                             <a href="healthcare_technology.php" class="text-[#981B46] text-[10px] font-bold uppercase mt-3 inline-block hover:underline">Know More</a>
                        </div>

                         <!-- Card 2 -->
                        <div class="bg-white text-dark p-6 rounded-2xl shadow-xl transform transition-transform hover:-translate-y-2 cursor-pointer group">
                             <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center text-[#981B46] text-xl mb-4 group-hover:bg-[#981B46] group-hover:text-white transition-colors">
                                <i class="fas fa-user-tie"></i>
                            </div>
                            <h3 class="font-bold text-lg mb-2">Consultancy</h3>
                            <p class="text-xs text-gray-500 leading-relaxed">Strategic planning and operational optimization.</p>
                            <a href="management_consultancy.php" class="text-[#981B46] text-[10px] font-bold uppercase mt-3 inline-block hover:underline">Know More</a>
                        </div>

                         <!-- Card 3 -->
                        <div class="bg-white text-dark p-6 rounded-2xl shadow-xl transform transition-transform hover:-translate-y-2 cursor-pointer group">
                             <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center text-[#981B46] text-xl mb-4 group-hover:bg-[#981B46] group-hover:text-white transition-colors">
                                <i class="fas fa-box-open"></i>
                            </div>
                            <h3 class="font-bold text-lg mb-2">Medical Products</h3>
                            <p class="text-xs text-gray-500 leading-relaxed">High-quality consumables and specialized tools.</p>
                            <a href="products.php" class="text-[#981B46] text-[10px] font-bold uppercase mt-3 inline-block hover:underline">Know More</a>
                        </div>

                         <!-- Card 4 -->
                        <div class="bg-white text-dark p-6 rounded-2xl shadow-xl transform transition-transform hover:-translate-y-2 cursor-pointer group">
                             <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center text-[#981B46] text-xl mb-4 group-hover:bg-[#981B46] group-hover:text-white transition-colors">
                                <i class="fas fa-project-diagram"></i>
                            </div>
                            <h3 class="font-bold text-lg mb-2">Turnkey Projects</h3>
                            <p class="text-xs text-gray-500 leading-relaxed">End-to-end execution of hospital projects.</p>
                            <a href="contact_us.php" class="text-[#981B46] text-[10px] font-bold uppercase mt-3 inline-block hover:underline">Know More</a>
                        </div>
                    </div>
                </div>

                <!-- 3. Right Content (Image) -->
                <div class="lg:w-1/4 hidden lg:block relative h-full">
                    <div class="absolute bottom-0 right-0 w-full h-[120%] -mt-10">
                        <img src="Assets/Images/Eq2.webp" class="w-full  object-contain drop-shadow-2xl animate-float" alt="Medical Equipment">
                    </div>

                    <!-- Card 5 (Life Science - Overlapping Image) -->
                    <div class="absolute -bottom-12 -left-20 w-[140%] z-30">
                        <div class="bg-white text-dark p-6 rounded-2xl shadow-2xl transform transition-transform hover:-translate-y-2 cursor-pointer group flex items-center gap-4">
                            <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center text-[#981B46] text-xl flex-shrink-0 group-hover:bg-[#981B46] group-hover:text-white transition-colors">
                                <i class="fas fa-dna"></i>
                            </div>
                            <div>
                                <h3 class="font-bold text-lg mb-1">Life Science</h3>
                                <p class="text-xs text-gray-500 leading-relaxed mb-1">Innovative technologies for clinical laboratory testing.</p>
                                <a href="healthcare_technology.php" class="text-[#981B46] text-[10px] font-bold uppercase inline-block hover:underline">Know More</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    
    <!-- PRODUCTS SECTION START (MINIMALIST DESIGN) -->
    <section class="py-24 relative bg-gray-50">
        
        <div class="container mx-auto max-w-7xl px-6">
            <!-- Header -->
            <div class="text-center mb-16 reveal">
                <h2 class="text-4xl font-bold text-dark mb-4">Our Products</h2>
                <p class="text-gray-500 max-w-2xl mx-auto leading-relaxed">
                    Our high quality equipment is designed to ensure the best patient outcomes. 
                    Explore our range of state-of-the-art medical solutions.
                </p>
            </div>
            
            <!-- Swiper Carousel -->
            <div class="relative px-12">
                <div class="swiper mySwiper w-full !overflow-visible pb-12 reveal reveal-delay-200">
                    <div class="swiper-wrapper">
                        
                        <!-- Product 1: MRI -->
                        <div class="swiper-slide group cursor-pointer">
                             <div class="flex flex-col items-center transition-transform duration-300 hover:-translate-y-2">
                                 <div class="h-64 w-full flex items-center justify-center mb-6">
                                    <img src="https://plus.unsplash.com/premium_photo-1681995326134-b5a0d30ce2c0?q=80&w=600&auto=format&fit=crop" class="max-h-full max-w-full object-contain drop-shadow-xl group-hover:drop-shadow-2xl transition-all duration-300">
                                 </div>
                                 <h3 class="text-xl font-bold text-dark group-hover:text-[#981B46] transition-colors">MRI Scanner</h3>
                             </div>
                        </div>

                        <!-- Product 2: Wheelchair -->
                        <div class="swiper-slide group cursor-pointer">
                             <div class="flex flex-col items-center transition-transform duration-300 hover:-translate-y-2">
                                 <div class="h-64 w-full flex items-center justify-center mb-6">
                                    <img src="https://images.unsplash.com/photo-1581091215367-9188514817da?q=80&w=600&auto=format&fit=crop" class="max-h-full max-w-full object-contain drop-shadow-xl group-hover:drop-shadow-2xl transition-all duration-300">
                                 </div>
                                 <h3 class="text-xl font-bold text-dark group-hover:text-[#981B46] transition-colors">Wheel chairs</h3>
                             </div>
                        </div>

                        <!-- Product 3: Ultrasound -->
                        <div class="swiper-slide group cursor-pointer">
                             <div class="flex flex-col items-center transition-transform duration-300 hover:-translate-y-2">
                                 <div class="h-64 w-full flex items-center justify-center mb-6">
                                    <img src="https://plus.unsplash.com/premium_photo-1661601700676-4d1e2e13295b?q=80&w=600&auto=format&fit=crop" class="max-h-full max-w-full object-contain drop-shadow-xl group-hover:drop-shadow-2xl transition-all duration-300">
                                 </div>
                                 <h3 class="text-xl font-bold text-dark group-hover:text-[#981B46] transition-colors">Ultrasound(USG)</h3>
                             </div>
                        </div>

                        <!-- Product 4: Monitor -->
                        <div class="swiper-slide group cursor-pointer">
                             <div class="flex flex-col items-center transition-transform duration-300 hover:-translate-y-2">
                                 <div class="h-64 w-full flex items-center justify-center mb-6">
                                    <img src="https://images.unsplash.com/photo-1551076805-e1869033e561?q=80&w=600&auto=format&fit=crop" class="max-h-full max-w-full object-contain drop-shadow-xl group-hover:drop-shadow-2xl transition-all duration-300">
                                 </div>
                                 <h3 class="text-xl font-bold text-dark group-hover:text-[#981B46] transition-colors">Patient Monitor</h3>
                             </div>
                        </div>

                         <!-- Product 5: Microscope -->
                        <div class="swiper-slide group cursor-pointer">
                             <div class="flex flex-col items-center transition-transform duration-300 hover:-translate-y-2">
                                 <div class="h-64 w-full flex items-center justify-center mb-6">
                                    <img src="https://images.unsplash.com/photo-1582719471384-15233e025389?q=80&w=600&auto=format&fit=crop" class="max-h-full max-w-full object-contain drop-shadow-xl group-hover:drop-shadow-2xl transition-all duration-300">
                                 </div>
                                 <h3 class="text-xl font-bold text-dark group-hover:text-[#981B46] transition-colors">Lab Microscope</h3>
                             </div>
                        </div>

                    </div>
                    <!-- Pagination Dots -->
                    <div class="swiper-pagination !bottom-0"></div>
                </div>
                
                <!-- Custom Navigation Buttons -->
                <div class="swiper-button-prev !text-gray-300 hover:!text-[#981B46] transition-colors after:!text-2xl"></div>
                <div class="swiper-button-next !text-gray-300 hover:!text-[#981B46] transition-colors after:!text-2xl"></div>
            </div>

        </div>
    </section>
    
    <!-- PARTNERS SECTION START -->
    <section class="py-12 bg-primary">
        <div class="container mx-auto max-w-7xl px-6">
            <h3 class="text-white text-center text-2xl font-bold mb-8 opacity-90 reveal">Our Partners</h3>
            <div class="swiper mySwiperPartners w-full">
                <div class="swiper-wrapper items-center">
                     <!-- Partner Logos -->
                    <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=BIO-RAD" alt="BIO-RAD" class="max-h-full object-contain">
                        </div>
                    </div>
                    <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=NORGEN" alt="NORGEN" class="max-h-full object-contain">
                        </div>
                    </div>
                    <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=INFAB" alt="INFAB" class="max-h-full object-contain">
                        </div>
                    </div>
                    <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=FUJIFILM" alt="FUJIFILM" class="max-h-full object-contain">
                        </div>
                    </div>
                    <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=EndoSoft" alt="EndoSoft" class="max-h-full object-contain">
                        </div>
                    </div>
                     <div class="swiper-slide flex justify-center p-4">
                        <div class="partner-logo bg-white p-3 rounded-lg opacity-80 hover:opacity-100 transition-opacity w-32 md:w-40 flex items-center justify-center h-20 shadow-sm">
                             <img src="https://placehold.co/200x80/white/981B46?text=3D+SYSTEMS" alt="3D SYSTEMS" class="max-h-full object-contain">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- LATEST NEWS -->
    <section class="py-20 relative">
         <div class="absolute inset-0 bg-pattern-dots opacity-20"></div>
        <!-- Heartbeat Line graphic placeholder -->
        <div class="container mx-auto max-w-7xl px-6 mb-8 relative z-10">
            <div class="flex items-center gap-4 text-primary text-opacity-20 reveal">
                 <i class="fas fa-heartbeat text-6xl"></i>
                 <div class="h-px bg-primary w-full opacity-20"></div>
            </div>
            <div class="flex justify-between items-end mt-4 reveal reveal-delay-100">
                <div>
                     <h5 class="text-primary font-bold uppercase text-sm mb-1">News</h5>
                     <h2 class="text-4xl font-bold text-dark">LATEST <span class="italic font-light">NEWS</span></h2>
                </div>
                <!-- Right arrow button -->
                <a href="#" class="w-10 h-10 bg-primary text-white rounded-full flex items-center justify-center hover:bg-dark transition-colors"><i class="fas fa-arrow-right"></i></a>
            </div>
        </div>

        <div class="container mx-auto max-w-7xl px-6 relative z-10">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- News 1 -->
                <div class="news-item group reveal reveal-delay-100">
                    <div class="overflow-hidden rounded-lg mb-4 h-56 relative">
                        <img src="https://images.unsplash.com/photo-1512413914633-b5043f4041ea?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        <span class="absolute top-4 left-4 bg-white text-dark text-xs font-bold px-2 py-1 rounded">04-12-20XX</span>
                    </div>
                    <h3 class="text-lg font-bold text-dark leading-tight mb-2 group-hover:text-primary transition-colors">Infrared Non-Contact Thermometer</h3>
                    <a href="#" class="text-sm font-bold text-gray-500 uppercase hover:text-primary">Read More</a>
                </div>
                <!-- News 2 -->
                <div class="news-item group reveal reveal-delay-200">
                    <div class="overflow-hidden rounded-lg mb-4 h-56 relative">
                         <img src="https://images.unsplash.com/photo-1532187863486-abf9dbad1b69?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                         <span class="absolute top-4 left-4 bg-white text-dark text-xs font-bold px-2 py-1 rounded">27-11-20XX</span>
                    </div>
                     <h3 class="text-lg font-bold text-dark leading-tight mb-2 group-hover:text-primary transition-colors">REILI – FUJIFILM AI Technology</h3>
                     <a href="#" class="text-sm font-bold text-gray-500 uppercase hover:text-primary">Read More</a>
                </div>
                 <!-- News 3 -->
                <div class="news-item group reveal reveal-delay-300">
                    <div class="overflow-hidden rounded-lg mb-4 h-56 relative">
                         <img src="https://images.unsplash.com/photo-1581093458682-2f1620133541?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                         <span class="absolute top-4 left-4 bg-white text-dark text-xs font-bold px-2 py-1 rounded">18-10-20XX</span>
                    </div>
                     <h3 class="text-lg font-bold text-dark leading-tight mb-2 group-hover:text-primary transition-colors">New Screening clinic in LHC</h3>
                     <a href="#" class="text-sm font-bold text-gray-500 uppercase hover:text-primary">Read More</a>
                </div>
            </div>
        </div>
    </section>

<?php include 'footer.php'; ?>