<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="relative h-[300px] flex items-center bg-[#981B46] overflow-hidden">
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <a href="products.php" class="hover:text-white transition-colors">Products</a>
            <span class="text-white/50">|</span>
            <span class="text-white">Details</span>
        </div>
        <h1 class="text-4xl md:text-5xl font-bold text-white tracking-wide">
            Digital MRI Scanner
        </h1>
    </div>
</section>

<!-- PRODUCT HERO -->
<section class="py-12 md:py-20">
    <div class="container mx-auto max-w-7xl px-6">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-20">
            
            <!-- LEFT: GALLERY -->
            <div>
                <!-- Main Image -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] p-8 md:p-16 mb-6 relative overflow-hidden group shadow-lg">
                    <img src="Assets/Images/Eq1.png" id="mainImage" class="w-full h-auto object-contain drop-shadow-2xl hover:scale-105 transition-transform duration-500">
                    
                    <!-- Navigation Arrows (Visual Only) -->
                    <button class="absolute left-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/10 hover:bg-white/20 backdrop-blur-md rounded-full text-white flex items-center justify-center transition-colors">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button class="absolute right-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/10 hover:bg-white/20 backdrop-blur-md rounded-full text-white flex items-center justify-center transition-colors">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>

                <!-- Thumbnails -->
                <div class="grid grid-cols-4 gap-4">
                    <div class="bg-gray-50 rounded-xl p-2 cursor-pointer border-2 border-[#981B46] hover:bg-gray-100 transition-colors">
                        <img src="Assets/Images/Eq1.png" class="w-full h-20 object-contain mix-blend-multiply">
                    </div>
                    <div class="bg-gray-50 rounded-xl p-2 cursor-pointer border border-transparent hover:border-gray-200 hover:bg-gray-100 transition-colors">
                        <img src="Assets/Images/Eq2.webp" class="w-full h-20 object-contain mix-blend-multiply">
                    </div>
                    <div class="bg-gray-50 rounded-xl p-2 cursor-pointer border border-transparent hover:border-gray-200 hover:bg-gray-100 transition-colors">
                        <img src="Assets/Images/Eq1.png" class="w-full h-20 object-contain mix-blend-multiply">
                    </div>
                    <div class="bg-gray-50 rounded-xl p-2 cursor-pointer border border-transparent hover:border-gray-200 hover:bg-gray-100 transition-colors">
                        <img src="Assets/Images/Eq2.webp" class="w-full h-20 object-contain mix-blend-multiply">
                    </div>
                </div>
            </div>

            <!-- RIGHT: DETAILS -->
            <div class="flex flex-col h-full">
                <!-- Title & Stock -->
                <div class="mb-6">
                    <div class="flex items-center gap-3 mb-2">
                         <span class="text-sm font-medium text-gray-400">Imaging Systems</span>

                    </div>
                    <h1 class="text-4xl font-bold text-dark mb-4">Digital MRI Scanner 3.0T</h1>
                    
                    <!-- No Stars Request Fulfilled -->
                    


                    <p class="text-gray-600 leading-relaxed max-w-lg mb-8">
                        Experience crystal clear diagnostics with our state-of-the-art MRI technology. This 3.0T system offers 
                        unparalleled imaging quality, faster scan times, and enhanced patient comfort features.
                        Includes full installation and 5-year service warranty.
                    </p>
                </div>



                <!-- Actions (No Cart/Buy) -->
                <div class="flex items-center gap-4 mb-10">
                    <a href="contact_us.php" class="flex-1 bg-[#981B46] text-white font-bold py-4 rounded-xl shadow-lg hover:shadow-xl hover:-translate-y-1 transition-all text-center">
                        Contact Sales
                    </a>
                    <button class="w-14 h-14 border border-gray-200 rounded-xl flex items-center justify-center text-gray-400 hover:text-[#981B46] hover:border-[#981B46] transition-colors">
                        <i class="far fa-heart text-xl"></i>
                    </button>
                    <button class="w-14 h-14 border border-gray-200 rounded-xl flex items-center justify-center text-gray-400 hover:text-[#981B46] hover:border-[#981B46] transition-colors">
                        <i class="fas fa-share-alt text-xl"></i>
                    </button>
                </div>

                <!-- Meta -->
                <div class="mt-auto space-y-2 text-sm">
                    <div class="flex gap-2">
                        <span class="font-bold text-dark min-w-[60px]">SKU:</span>
                        <span class="text-gray-500">MRI-3000-XJ</span>
                    </div>
                    <div class="flex gap-2">
                        <span class="font-bold text-dark min-w-[60px]">Tags:</span>
                        <span class="text-gray-500">Imaging, Radiology, MRI, Hospital</span>
                    </div>
                    <div class="flex gap-2">
                        <span class="font-bold text-dark min-w-[60px]">Share:</span>
                        <div class="flex gap-3 text-gray-400">
                            <a href="#" class="hover:text-[#981B46]"><i class="fab fa-facebook-f"></i></a>
                            <a href="#" class="hover:text-[#981B46]"><i class="fab fa-twitter"></i></a>
                            <a href="#" class="hover:text-[#981B46]"><i class="fab fa-linkedin-in"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- TABS Info -->
<section class="py-12 bg-white">
    <div class="container mx-auto max-w-7xl px-6">
             <button class="pb-4 border-b-2 border-[#981B46] text-[#981B46] font-bold text-lg">Description</button>
         
         <div class="max-w-4xl text-gray-600 leading-relaxed">
             <h3 class="text-dark font-bold text-xl mb-4">Product Specifications</h3>
             <p class="mb-4">
                 The Magnetom 2025 is designed to meet the rigorous demands of modern healthcare facilities. 
                 With its advanced gradient performance and wide bore design, it delivers exceptional image quality 
                 while maximizing patient comfort and throughput.
             </p>
             <div class="bg-gray-50 p-6 rounded-2xl grid grid-cols-1 md:grid-cols-2 gap-4 text-sm mt-8">
                 <div class="flex justify-between border-b border-gray-200 pb-2">
                     <span class="font-bold text-dark">Field Strength</span>
                     <span>3.0 Tesla</span>
                 </div>
                 <div class="flex justify-between border-b border-gray-200 pb-2">
                     <span class="font-bold text-dark">Bore Size</span>
                     <span>70 cm</span>
                 </div>
                 <div class="flex justify-between border-b border-gray-200 pb-2">
                     <span class="font-bold text-dark">Gradient</span>
                     <span>45 mT/m</span>
                 </div>
                 <div class="flex justify-between border-b border-gray-200 pb-2">
                     <span class="font-bold text-dark">Slew Rate</span>
                     <span>200 T/m/s</span>
                 </div>
             </div>
         </div>
    </div>
</section>

<!-- RELATED PRODUCTS -->
<section class="py-20 bg-[#F9F9F9]">
    <div class="container mx-auto max-w-7xl px-6">
        <div class="flex items-center justify-between mb-12">
            <h2 class="text-3xl font-bold text-dark">Related Products</h2>
            <a href="products.php" class="text-[#981B46] font-bold hover:underline">View All</a>
        </div>

        <!-- Swiper Container -->
        <div class="swiper relatedProductsSwiper overflow-visible pb-12">
            <div class="swiper-wrapper">
                <?php for($i=1; $i<=8; $i++): ?>
                <div class="swiper-slide">
                    <a href="product_details.php" class="block h-full group">
                        <!-- Image -->
                        <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[280px] flex items-center justify-center mb-4 overflow-hidden shadow-md transition-shadow group-hover:shadow-xl">
                            <!-- Badge -->
                            <span class="bg-white text-[#981B46] text-[10px] font-bold px-2 py-1 rounded-full absolute top-4 left-4 z-10 shadow-sm">
                                <?php echo ($i % 3 == 0) ? 'New' : '-10%'; ?>
                            </span>
                            
                            <!-- Image Asset -->
                            <img src="Assets/Images/<?php echo ($i%2==0) ? 'Eq2.webp' : 'Eq1.png'; ?>" class="w-full h-full object-contain drop-shadow-xl group-hover:scale-110 transition-transform duration-500">
                        </div>
                        
                        <!-- Info (No Price) -->
                        <div class="text-center md:text-left px-2">
                             <p class="text-[10px] text-gray-400 mb-1 uppercase tracking-wider font-semibold">Medical Equipment</p>
                             <h4 class="font-bold text-dark text-lg leading-tight group-hover:text-[#981B46] transition-colors">Related Product <?php echo $i; ?></h4>
                        </div>
                    </a>
                </div>
                <?php endfor; ?>
            </div>
            <!-- Pagination -->
            <div class="swiper-pagination !bottom-0"></div>
        </div>

        <!-- Initialize Swiper -->
        <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var swiper = new Swiper(".relatedProductsSwiper", {
                    slidesPerView: 1,
                    spaceBetween: 24,
                    loop: true,
                    grabCursor: true,
                    autoplay: {
                        delay: 3000,
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                        dynamicBullets: true,
                    },
                    breakpoints: {
                        640: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        768: {
                            slidesPerView: 3,
                            spaceBetween: 24,
                        },
                        1024: {
                            slidesPerView: 4,
                            spaceBetween: 30,
                        },
                    },
                });
            });
        </script>
    </div>
</section>

<?php include 'footer.php'; ?>
