<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="relative h-[40vh] min-h-[350px] flex items-center overflow-hidden">
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?auto=format&fit=crop&q=80&w=2000" alt="Background" class="w-full h-full object-cover object-center">
    </div>
    <div class="absolute top-0 left-0 h-full w-full bg-gradient-to-r from-[#981B46]/95 via-[#981B46]/80 to-transparent"></div>
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2 reveal">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <span class="text-white">Products</span>
        </div>
        <h1 class="text-5xl md:text-6xl font-bold text-white tracking-wide reveal reveal-delay-100">
            Our Products
        </h1>
    </div>
</section>

<!-- CONTENT -->
<section class="py-20 relative">
    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        
        <!-- Filter Tabs (Optional Visual) -->
        <div class="flex justify-between items-center mb-12 flex-wrap gap-4">
             <h2 class="text-3xl font-bold text-dark">Latest Products</h2>
             <div class="flex gap-2">
                 <button class="px-4 py-2 bg-dark text-white rounded-full text-sm font-medium">All</button>
                 <button class="px-4 py-2 bg-gray-100 text-gray-600 rounded-full text-sm font-medium hover:bg-gray-200">Imaging</button>
                 <button class="px-4 py-2 bg-gray-100 text-gray-600 rounded-full text-sm font-medium hover:bg-gray-200">Furniture</button>
                 <button class="px-4 py-2 bg-gray-100 text-gray-600 rounded-full text-sm font-medium hover:bg-gray-200">Consumables</button>
             </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            
            <!-- Product 1 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                    <!-- Badge -->
                    <span class="bg-white text-[#981B46] text-[10px] font-bold px-3 py-1 rounded-full absolute top-6 left-6 z-10 shadow-sm">Best Seller</span>
                    
                    <!-- Image -->
                    <img src="Assets/Images/Eq1.png" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Imaging Systems</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">Digital MRI Scanner</h3>
                </div>
            </a>

            <!-- Product 2 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                    <!-- Badge -->
                    <span class="bg-white/10 backdrop-blur-md text-white border border-white/20 text-[10px] font-bold px-3 py-1 rounded-full absolute top-6 left-6 z-10">New Arrival</span>
                    
                    <!-- Image -->
                    <img src="Assets/Images/Eq2.webp" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Vitals Monitoring</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">ICU Patient Monitor</h3>
                </div>
            </a>

            <!-- Product 3 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                    <!-- Badge -->
                    <span class="bg-[#981B46] text-white border border-white/10 text-[10px] font-bold px-3 py-1 rounded-full absolute top-6 left-6 z-10">Featured</span>
                    
                    <!-- Image -->
                    <img src="Assets/Images/Eq1.png" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Advanced Imaging</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">High-Res CT Scanner</h3>
                </div>
            </a>

            <!-- Product 4 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                     <!-- Image -->
                    <img src="Assets/Images/Eq2.webp" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Diagnostic</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">Portable Ultrasound</h3>
                </div>
            </a>

            <!-- Product 5 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                    <!-- Badge -->
                    <span class="bg-white text-[#981B46] text-[10px] font-bold px-3 py-1 rounded-full absolute top-6 left-6 z-10 shadow-sm">Top Rated</span>

                    <!-- Image -->
                    <img src="Assets/Images/Eq1.png" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Radiology</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">X-Ray System</h3>
                </div>
            </a>

            <!-- Product 6 -->
            <a href="product_details.php" class="block">
                <!-- Image Container -->
                <div class="bg-[radial-gradient(circle_at_center,#981B46_0%,#4a0d22_100%)] rounded-[2rem] relative p-8 h-[350px] flex items-center justify-center mb-6 group overflow-hidden shadow-lg">
                    
                    <!-- Image -->
                    <img src="Assets/Images/Eq2.webp" class="w-full h-full object-contain drop-shadow-2xl group-hover:scale-105 transition-transform duration-500">
                </div>
                
                <!-- Content -->
                <div>
                     <p class="text-xs text-gray-400 mb-1">Emergency</p>
                     <h3 class="text-xl font-bold text-dark mb-1 leading-tight hover:text-[#981B46] transition-colors">Automated Defibrillator</h3>
                </div>
            </a>
            
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>
