<?php include 'header.php'; ?>

<!-- PAGE HEADER (Matches about_us.php style) -->
<section class="relative h-[40vh] min-h-[350px] flex items-center overflow-hidden">
    <!-- Background Image -->
    <div class="absolute inset-0 z-0">
        <img src="https://images.unsplash.com/photo-1576091160399-112ba8d25d1d?auto=format&fit=crop&q=80&w=2000" alt="Services Background" class="w-full h-full object-cover object-center">
    </div>

    <!-- Curved Overlay -->
    <div class="absolute top-0 left-0 h-full w-[120%] md:w-[70%] bg-gradient-to-r from-[#981B46]/95 via-[#981B46]/80 to-transparent" 
         style="clip-path: ellipse(90% 100% at 0% 50%);">
    </div>

    <!-- Content -->
    <div class="container mx-auto max-w-7xl px-6 relative z-10 pl-10 md:pl-20">
        <div class="flex items-center gap-2 text-sm font-medium text-white/80 mb-2 reveal">
            <a href="index.php" class="hover:text-white transition-colors">Home</a>
            <span class="text-white/50">|</span>
            <span class="text-white">Services</span>
        </div>
        <h1 class="text-5xl md:text-6xl font-bold text-white tracking-wide reveal reveal-delay-100">
            Our Services
        </h1>
    </div>
</section>

<!-- MAIN CONTENT SECTION (Transparent Background) -->
<section class="py-20 relative">
    <div class="container mx-auto max-w-7xl px-6 relative z-10">
        
        <!-- Large Headline -->
        <div class="flex flex-col md:flex-row justify-between items-end mb-16 reveal">
            <h2 class="text-4xl md:text-6xl font-black text-dark leading-tight uppercase max-w-4xl">
                Comprehensive<br>
                Solutions For<br>
                Modern <span class="text-primary">Healthcare</span>
            </h2>
            <div class="hidden md:block text-right pb-2">
                <i class="fas fa-th-large text-2xl text-primary animate-pulse"></i>
                <p class="text-xs text-gray-500 mt-2 max-w-[150px]">Take a step toward perfect care with modern technology.</p>
            </div>
        </div>

        <!-- Denty-style Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 h-auto lg:h-[600px]">
            
            <!-- Left Card: Advanced Diagnostics -->
            <div class="group relative bg-[#0B1221] rounded-3xl p-8 flex flex-col justify-between overflow-hidden shadow-2xl reveal reveal-delay-100 border border-gray-800">
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-4">
                        <h3 class="text-2xl font-bold text-white uppercase leading-none">Advanced<br>Diagnostics</h3>
                        <div class="w-10 h-10 rounded-lg bg-white/10 flex items-center justify-center text-white hover:bg-primary transition-colors cursor-pointer">
                            <i class="fas fa-arrow-up rotate-45"></i>
                        </div>
                    </div>
                    <p class="text-gray-400 text-sm max-w-[80%]">High-precision imaging for accurate and early detection.</p>
                </div>

                <!-- 3D Image Placeholder -->
                <div class="absolute bottom-[-10%] left-1/2 transform -translate-x-1/2 w-full h-3/4 pointer-events-none transition-transform duration-700 group-hover:scale-110">
                    <img src="https://images.unsplash.com/photo-1516549655169-df83a092fc43?auto=format&fit=crop&q=80&w=600" class="w-full h-full object-contain filter drop-shadow-2xl mix-blend-lighten opacity-80" alt="Scanner 3D">
                </div>
                
                <!-- Rotating Lines Decoration -->
                <div class="absolute bottom-10 left-1/2 transform -translate-x-1/2 w-64 h-12 border-t border-b border-white/10 rounded-[100%] rotate-x-60 animate-spin-slow"></div>
            </div>

            <!-- Center Card: Doctor / CTA -->
            <div class="relative rounded-3xl overflow-hidden shadow-2xl reveal reveal-delay-200 group">
                <img src="https://images.unsplash.com/photo-1622253692010-333f2da6031d?auto=format&fit=crop&q=80&w=800" class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105">
                
                <!-- Gradient Overlay -->
                <div class="absolute inset-0 bg-gradient-to-t from-dark/90 via-transparent to-transparent"></div>

                <!-- Content -->
                <div class="absolute bottom-0 left-0 w-full p-10 text-center">
                    <h3 class="text-3xl font-bold text-white mb-6 uppercase leading-tight">
                        Find The<br>
                        Right Solution<br>
                        For You
                    </h3>
                    <a href="contact_us.php" class="inline-block bg-white text-dark font-bold uppercase tracking-wide py-4 px-8 rounded-lg hover:bg-primary hover:text-white transition-colors duration-300">
                        Book Consultation
                    </a>
                </div>
            </div>

            <!-- Right Card: Precision Robotics -->
            <div class="group relative bg-[#0B1221] rounded-3xl p-8 flex flex-col justify-between overflow-hidden shadow-2xl reveal reveal-delay-300 border border-gray-800">
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-4">
                        <h3 class="text-2xl font-bold text-white uppercase leading-none">Precision<br>Robotics</h3>
                        <div class="w-10 h-10 rounded-lg bg-white/10 flex items-center justify-center text-white hover:bg-primary transition-colors cursor-pointer">
                            <i class="fas fa-arrow-up rotate-45"></i>
                        </div>
                    </div>
                    <p class="text-gray-400 text-sm max-w-[80%]">State-of-the-art robotic assistance for complex procedures.</p>
                </div>

                <!-- 3D Image Placeholder -->
                <div class="absolute bottom-[-5%] right-[-10%] w-full h-3/4 pointer-events-none transition-transform duration-700 group-hover:scale-110 group-hover:rotate-6">
                    <img src="https://images.unsplash.com/photo-1581093450021-4a7360e9a6b5?auto=format&fit=crop&q=80&w=600" class="w-full h-full object-contain filter drop-shadow-2xl mix-blend-lighten opacity-90" alt="Robotic Arm">
                </div>

                <!-- Tech Lines -->
                <div class="absolute top-1/2 right-10 w-20 h-[1px] bg-white/20"></div>
                <div class="absolute top-1/2 right-10 w-[1px] h-20 bg-white/20"></div>
            </div>

        </div>

        <!-- Additional Services Grid (Smaller) -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-8 reveal reveal-delay-300">
            <div class="bg-white/10 backdrop-blur-md border border-white/20 p-6 rounded-2xl hover:bg-white/20 transition-all cursor-pointer group">
                <i class="fas fa-heartbeat text-3xl text-primary mb-3 group-hover:scale-110 transition-transform block"></i>
                <h4 class="font-bold text-dark text-sm uppercase">Cardiology</h4>
            </div>
            <div class="bg-white/10 backdrop-blur-md border border-white/20 p-6 rounded-2xl hover:bg-white/20 transition-all cursor-pointer group">
                <i class="fas fa-dna text-3xl text-primary mb-3 group-hover:scale-110 transition-transform block"></i>
                <h4 class="font-bold text-dark text-sm uppercase">Genetics</h4>
            </div>
            <div class="bg-white/10 backdrop-blur-md border border-white/20 p-6 rounded-2xl hover:bg-white/20 transition-all cursor-pointer group">
                <i class="fas fa-brain text-3xl text-primary mb-3 group-hover:scale-110 transition-transform block"></i>
                <h4 class="font-bold text-dark text-sm uppercase">Neurology</h4>
            </div>
            <div class="bg-white/10 backdrop-blur-md border border-white/20 p-6 rounded-2xl hover:bg-white/20 transition-all cursor-pointer group">
                <i class="fas fa-baby text-3xl text-primary mb-3 group-hover:scale-110 transition-transform block"></i>
                <h4 class="font-bold text-dark text-sm uppercase">Pediatrics</h4>
            </div>
        </div>

    </div>
</section>

<?php include 'footer.php'; ?>
